#ifndef MAP_H
#define MAP_H

/* Dernier Changement : Romain 0h20 
Inclu dans : main.cpp 
La marche arriere est un reliquat a supprimer */

#include "obsCarr.h"
#include "pointParcours.h"
#include "nVector.h"
#include "controle.h"
#include "Objectif/objectif.h"
#include "../Odometry/Odometry.h"
#include "../Functions/defines.h"
#include "../AX12/AX12.h"
#include "../../StepperMotor/Stepper.h"

#define X_START_VERT 110
#define X_START_VIOLET 2890
#define Y_START 850

class map {
public:
    map (Odometry* nodo, AX12 * np, ControlleurPince * npince, int ncouleur, int nformation);
    void addObs (obsCarr nobs);
    void addObj (objectif nobj);
    void FindWay (point dep, point arr);
    void FindWay (float depX, float depY, float arrX, float arrY);
    void Execute (int obj);
    void Execute ();
    void Execute (float XObjectif, float YObjectif);
    void Build();
    nVector<pointParcours>& getParc () { return path; }
    bool& getEnded () { return endedParc; }

protected:
    nVector<obsCarr> obs;
    nVector<pointParcours> path;
    nVector<objectif> objectifs;

    bool endedParc; // Definit s'il existe un chemin parcourable dans le dernier FindWay
    int couleur, formation;
    Odometry* Codo;
    AX12 * Parasol;
    ControlleurPince * pince;

    float min_x_table, min_y_table, max_x_table, max_y_table;

    void Build_formation_1 (int couleur);
    void Build_formation_2 (int couleur);
    void Build_formation_3 (int couleur);
    
    void Build_Objectives ();
};

#endif