#ifndef MBED_STEPPER_H
#define MBED_STEPPER_H

#include "mbed.h"

class Stepper
{
public:
    Stepper(PinName _en, PinName _stepPin, PinName dir, PinName _minEndStop, float step_per_mm);
    bool step(int _number, int _dir, float _speed, bool _async=false);
    bool mm(int _number, int _dir, bool _async=false);
    bool mm(float _distance, bool _async=false);
    
    bool done();
    
    void enable();
    void disable();
    
    int getEndStop() {return minEndStop.read();}
    
    void tick();
    
    float Step_Per_MM;
private:
    DigitalOut en;
    DigitalOut stepPin;
    DigitalOut direction;
    DigitalIn minEndStop;
    
    int number;
    int dir;
    float speed;
    bool async;
    Ticker ticker;
    
};


#endif