#include "func.h"
#include "Map/map.h"

#define ATTENTE 0
#define GO 1
#define STOP 2

/* Déclaration des différents éléments de l'IHM */
class S { 
public:
    S () :  mybutton(USER_BUTTON), button(USER_BUTTON), led(LED1), bleu(PC_5), blanc(PC_6), rouge(PC_8)
            left_hand(PA_15, PB_7, 4, 250000), right_hand(PA_15, PB_7, 1, 250000),
            capt1(PA_4), capt2(PB_0), capt3(PC_1), capt4(PC_0),
            RMot(NC, PB_10, PA_8), ZMot(NC, PB_5, PB_4), LMot(NC, PB_3, PA_10),
            EndR(PB_15), EndZ(PB_14), EndL(PB_13),
            logger(PA_9, PA_10), roboclaw(460800, PA_11, PA_12), odo(61.7, 61.8, ENTRAXE, 4096, roboclaw) {
        
        i = 0;
        state = 0;
        EL = false;
        EZ = false
        ER = false;            
    }
            
    static InterruptIn mybutton;
    static DigitalIn button;
    static DigitalOut led;
    static DigitalOut bleu;
    static DigitalOut blanc;
    static DigitalOut rouge;
    
    /* AX12 */
    static AX12 left_hand;
    static AX12 right_hand;
    
    /* Sharp */
    static AnalogIn capt1;
    static AnalogIn capt2;
    static AnalogIn capt3;
    static AnalogIn capt4;
    
    /* Moteurs pas à pas */
    static Stepper RMot;
    static Stepper ZMot;
    static Stepper LMot;
    /* Fins de course */
    static InterruptIn EndR;
    static InterruptIn EndZ;
    static InterruptIn EndL;
    
    static Ticker ticker;
    
    //Serial logger(USBTX, USBRX);
    static Serial logger;
    static RoboClaw roboclaw;
    static Odometry odo;
    
    static int i;
    static state;
    static bool EL;
    static EZ;
    static ER;
}    

void init(void);

/* Debut du programme */
int main(void)
{
    init();
    
    odo.setPos(110, 1000, 0);
    map m(&odo);
    m.addObs(obsCarr (1250, 1000, 220, 220));
    m.addObs(obsCarr (1500, 750, 220, 220));
    m.addObs(obsCarr (1500, 1250, 220, 220));
    
    m.Execute(1000,1000);
    m.Execute(1500,1000);
    m.Execute(1500,1500);
    m.Execute(110,1000);
    
    odo.GotoThet(0);
    
    while(1) JPO();
}

void init(void)
{
    roboclaw.ForwardM1(ADR, 0);
    roboclaw.ForwardM2(ADR, 0);
    logger.baud(9600);
    logger.printf("Hello from main !\n\r");
    wait_ms(500);
    bleu = 1, blanc = 1, rouge = 1;
    wait_ms(1000);
    bleu = 0, blanc = 0, rouge = 0;
    
    while(S::button);
    wait(1);
    
    init_ax12();
    init_interrupt();
    wait_ms(100);
    logger.printf("End init\n\r");
}
