#include "mbed.h"
#include <AnalogOut.h>
//AnalogOut(p18);
DigitalOut myled(LED1);
Serial pc(USBTX, USBRX); // tx, rx

//void Initialize();

// prototypes
char DisplayMenu();
void SimpleIOTest();
void AnalogOutTest();
void AnalogInTest();
void PwmOutTest();
void TimerIntInit();
void ExternalIntInit();
void LinearOpticalArrayTest();
void BluetoothTest();
void TimerISR();

int main() 
{
    char Key;
    //Initialize();
    while(1) 
    {
        Key=DisplayMenu();
        switch(Key)
        {
            case ('1'):
            {
                SimpleIOTest();
                break;
            }
            case ('2'):
            {
                AnalogOutTest();
                break;
            }
            case ('3'):
            {
                AnalogInTest();
                break;
            }
            case ('4'):
            {
                PwmOutTest();
                break;
            }
            case ('5'):
            {
                TimerIntInit();
                break;
            }
            case ('6'):
            {
                ExternalIntInit();
                break;
            }
            case ('7'):
            {
                LinearOpticalArrayTest();
                break;
            }
            case ('8'):
            {
                BluetoothTest();
                break;
            }
            default:
            {
                printf("\r\nInvalid keypress entry.\r\n");
                break;
            }
        }// close switch
    }// end infinite loop
    
    //return (0);
}// close main

char DisplayMenu()
{
    // test code for a display function
    unsigned int ScanData[] = {};
    
    unsigned short 
    
    int i = 0;
    for(i = 0; i < 128; i++)
    {
        if 
    }
}

void SimpleIOTest()
{
    DigitalOut StatusLED(p25);
    DigitalIn LimitSW(p26);

    bool z;
    char x;
    
    do 
    {
        z = LimitSW;
        StatusLED = z; 
        pc.printf("\r\nDigital input = %x",z);
        pc.printf("\r\nPress space to continue - any other key to quit");
        x = pc.getc();
    }
    while (x == 0x20); 
}

void AnalogIOTest()
{
    AnalogOut AnalogOutPin(p18);
    AnalogIn Ain19(p19);

    unsigned short x, Aout;
    Aout = 0;

    do
    {
        AnalogOutPin.write_u16(Aout);
        x = Ain19.read_u16();
        printf("\r\nAnalog output = %x, Analog input = %x", Aout, x);
        Aout = Aout + 4096;
    }
    while(pc.getc() == ' ');
}

void AnalogInTest()
{
    AnalogIn Ain19(p19);
    char inputChar = ' ';
    unsigned short analogIn;
    float percent;
    
    pc.printf("\r\nPress space to continue - any other key to quit");
    
    while(inputChar == ' ')
    {
        // sample analog input
        analogIn = Ain19.read_u16();
        
        // convert to percentage
        percent = (float) analogIn/65535;
        
        pc.printf("\r\nAnalog input = %u (%f %%)", analogIn, percent);
        
        inputChar = pc.getc();
    }
}

void AnalogOutTest()
{
    AnalogOut AnalogOutPin(p18);
    
    char firstNum;
    char secondNum;
    unsigned short analogOut;
    
    pc.printf("\r\nEnter the voltage percentage, press q to quit");
    while(firstNum != 'q' || firstNum != 'q')
    {
        pc.printf("\r\nEnter Voltage Percentage:");
        firstNum = pc.getc();
        secondNum = pc.getc();
        
        // convert to integer and set the analog out
        analogOut = (firstNum - '0')*10 + (secondNum - '0');
        
        AnalogOutPin.write_u16(analogOut);
    }
}

void PwmOutTest()
{
    PwmOut PwmP21(p21);

float y, T;
T=0.001;

PwmP21.period(T);
pc.printf("\n\rEnter on-time for PwmP21 followed by enter: ");
pc.scanf("%f",&y);
pc.printf("\n\n\rPwm period = %f, Pwm on-time = %f", T, y);
PwmP21.pulsewidth(y);
}

void TimerIntInit()
{
    Ticker PeriodicInt;
    char x;

    pc.printf("\r\nPeiodic interrupts toggles LED2");
    //PeriodicInt.attach(&TimerISR, 0.0625); // ISR Address, int interval
    
    do x=pc.getc();  while (x!='q'); // Wait for interrupts

}

void TimerISR() 
{
    //led2=1;
    //led2 = !led2;
}

void ExternalIntInit()
{
}

void LinearOpticalArrayTest()
{
}

void BluetoothTest()
{
    Serial pc(USBTX, USBRX); // tx, rx
    Serial BluetoothSerial(p28, p27);  // tx, rx

    char x;
    BluetoothSerial.baud(9600);
    do 
    {
        if (pc.readable()) 
        {
            x=pc.getc();
            // Receive keyboard entry and send to Bluetooth channel
            BluetoothSerial.putc(x); 
            pc.putc(x); //Echo keyboard entry
        }
    }
    while (x!='q');
}