#include "mbed.h"

Ticker toggle_led_ticker;
Ticker sampler;


// I/Os
AnalogIn analog_sample(A0);      // Analog IN A0
AnalogIn threshold_vlaue(A1);    // Threshold A1
AnalogOut my_output(PA_4);       // Analog OUT A2
DigitalOut led1(LED1);
DigitalOut do0(PC_8);
DigitalOut do1(PC_9);

float analog_value;
//uint16_t analog_value;

void toggle_led() {
    led1 = !led1;
}

void ADCisr() {
    do0 = 1;
    analog_value = analog_sample.read(); // Converts and read the analog input value (value from 0x0000 to 0xFFFF)
    my_output.write(analog_value);
}

int main() {
    // Init the ticker with the address of the function (toggle_led) to be attached and the interval (100 ms)
    toggle_led_ticker.attach(&toggle_led, 0.5);
    sampler.attach(&ADCisr, 0.000125); // the address of the function to be attached (&..) and the interval (8 Khz)
    while (true) {
        // Do other things...
        do0 = 0;
    sleep();        // Enter in sleep
    }
}