#ifndef ENCODER_H
#define ENCODER_H

#include "mbed.h"

/** Encoder class.
 * Manages one magnetic encoder AS5600. Reads its absolute value and performs
 * the conversion of the value to incremental valeu.
 */
class Encoder
{
public:
    Encoder(I2C* i2c_in, Mutex* mutex_in, char invert_in);
    long int readAbsolute();
    long int incremental();
    long int readIncrementalValue();

private:
    I2C* _i2c;
    Mutex* _mutex;
    short int prev_L;
    long int total_L;
    char _invert;
};

#endif