#include "mbed.h"
#include "Koala.h"


Serial PC(USBTX,USBRX);
Koala koala(p28,p27,38400);  // tx, rx, baudrate

// Just to check different speeds.
#define SPEED   3
#define LS      3
#define RS     -5


int main() {

    PC.baud(38400);

    PC.printf("\r\nKoala Test Code\r\n");
    PC.printf("=================================\r\n");
    PC.printf("Initialising...\r\n");


    PC.printf("Initialising position (0,0)\r\n%c\r\n",koala.set_pos_cnt(0,0));

    PC.printf("Moving with speed (%d,%d)\r\n%c\r\n",LS*SPEED,RS*SPEED,koala.set_speed(LS*SPEED,RS*SPEED));
    wait(2);
    PC.printf("Stop moving...\r\n%c\r\n",koala.set_speed(0,0));
    wait(0.5);

    int nCountL,nCountR;
    koala.read_position(&nCountL,&nCountR);
    PC.printf("Counts:\t%d\t%d\r\n",nCountL,nCountR);
    wait(1);

    /* Read channel input
    for (int i=0;i<1000;i++) {

        PC.printf("Ears:\t%d\t%d\r\n",koala.read_channel(0),koala.read_channel(1));
    }
    */
}
