#include "Koala.h"

Koala::Koala(PinName tx, PinName rx, int baudrate) :  Serial(tx, rx) {

    this->baud(baudrate);
    this->format(8,Serial::None,1);
    set_speed(0,0);
    set_pos_cnt(0,0);
}


void Koala::dummyread() {

    char dummy = this->getc();
}

char Koala::set_speed(int speedL,int speedR) {

    this->printf("D,%d,%d\n",speedL,speedR);
    char reply = this->getc();
    dummyread();
    dummyread();
    return reply;
}


char Koala::set_pos_cnt(int posL,int posR) {

    this->printf("G,%d,%d\n",posL,posR);
    char reply = this->getc();
    dummyread();
    dummyread();
    return reply;
}

void Koala::read_position(int* nPosL, int* nPosR) {

    int * PosL, * PosR;
    PosL = (int*)nPosL;
    PosR = (int*)nPosR;

    this->printf("H\n");
    this->scanf("h,%d,%d",PosL,PosR);
    dummyread();
    dummyread();
}

int Koala::read_channel(int channel) {

    int reply;
    this->printf("I,%d\n",channel);
    this->scanf("i,%d",&reply);
    dummyread();
    dummyread();
    return reply;
}