#include "mbed.h"
#include <stdio.h>
#include <math.h>
#include "ADNS5020EN.h"

ADNS5020EN adns(p5,p6,p7,p21,p22,0.1);
Serial PC(USBTX,USBRX);

DigitalIn button(p25);

// Timers
Timer ticktok;  // Runtime Timer
Timer dtimer;   // Timer for data manipulation
Timer flash;    // LED timer

#define PI     3.14159265    // Pi (math)

float accum_dx = 0.00, accum_dy = 0.00;

// output function
void action_data() {
    if (dtimer.read_ms()>=100) {
        float phi = 0, d = 0;
        float y = -1*accum_dy;
        float x = accum_dx;

        if ((y != 0) || (x != 0)) {
            phi = atan2(x,y);
            d = sqrt(pow(y,2) + pow(x,2));
        }
        PC.printf(" P = %+.4f rad\t", phi);
        PC.printf(" D = %+.4f mm\t", d);
        if (d<10.00)
            PC.printf("\t");
        PC.printf("|   deltaX = %+.4f mm\t", x);
        PC.printf(" deltaY = %+.4f mm\r\n", y);
        accum_dx = 0;
        accum_dy = 0;
        dtimer.reset();
    }
}

int main() {
    PC.baud(38400);

    PC.printf("\r\nADNS-5020EN mouse chip\r\n");
    PC.printf("=================================\r\n");
    PC.printf("Initialising...\r\n");

    float a_dx = 0, a_dy = 0;
    dtimer.start();
    while (button) {

        // read the mouse chip data
        adns.read_deltas_mm(&a_dx,&a_dy);
        accum_dx += a_dx;
        accum_dy += a_dy;
        
        // act
        action_data();

        wait_us(100);

    }
    
    PC.printf("False Readings: %d\r\n",adns.falser());    
    
    wait(1);
    
    int reply = adns.changeCPI(1);
    
    PC.printf("CPI = 0x%X\r\n",reply);    
    wait(1);
    adns.end();
}
