#include "main.h"

// setting the in and out pins correctly for the encoder and the direction of both motors
DigitalIn encoderB1(D10);
DigitalIn encoderA1(D11);
DigitalIn encoderA2(D12);
DigitalIn encoderB2(D13);
DigitalOut directionLeft(D7);
DigitalOut directionRight(D4);

// creating the objects for both motors using Fast PWM to be able to control the speed of the motors
PwmOut motorLeft(D6);
PwmOut motorRight(D5);

// creating the objects for both encoders using QEI to be able to read out the encoders
QEI encoderLeft(D10,D11,NC,4200);
QEI encoderRight(D13,D12,NC,4200);

int motorInitialize(void){
    motorLeft.period(0.0001);           // setting the PWM period for the motors
    motorRight.period(0.0001);
    motorLeft.write(0);                 // writing 0 PWM to define both motors states
    motorRight.write(0);
    return 0;
}
   
    
int motorCalibrate(void){               // motor calibrate function, this function goeos through the steps that are needed in order for the motors to be calibrated

    int counter = 0;                    // defining some variables that are needed within the function          
    int stillMovingCounter = 0;
    int firstCounts;
    int secondCounts;
    int moving = 3;
    
    directionRight = 1;
    motorRight.write(0.6);              // first turning on the right motor
    
    while (moving >= 1 || stillMovingCounter <= 2) {            // this while statements checks if the motor is still moving, and if it is not it will stop
        if (moving >= 1) {
            firstCounts = encoderRight.getPulses();
            wait(0.1);
            secondCounts = encoderRight.getPulses();            // checking the encoder steps to see if there is still a difference
            moving = secondCounts - firstCounts;                // calculating the differnce
            stillMovingCounter = 0;
//          pc.printf("moving value is %i \r\n", moving);
        }
        else {
            stillMovingCounter = stillMovingCounter + 1;        // this else statment is a sort of buffer that was maybe needed if the encoder was to fast with reading it. 
//          pc.printf("counter value is %i\r\n",stillMovingCounter);
        }
    }
    motorRight.write(0);                    // then stop the motor
    encoderRight.reset();                   // and reset the angle to zero
//  pc.printf("Right motor calibrated\r\n");   
    
    moving = 3;                             // resetting a few variables for the calibration process of the second motor 
    stillMovingCounter = 0;
    
    directionLeft = 1;                      // from here on it is exactly the same but then for the left motor. so for more detail see the code and comments above.
    motorLeft.write(0.6); 
    
     while (moving >= 1 || stillMovingCounter <= 2) {
        if (moving >= 1) {
            firstCounts = encoderLeft.getPulses();
            wait(0.1);
            secondCounts = encoderLeft.getPulses();
            moving = secondCounts - firstCounts;
            stillMovingCounter = 0;
//          pc.printf("moving value is %i \r\n", moving);
        }
        else {
            stillMovingCounter = stillMovingCounter + 1;
//          pc.printf("counter value is %i\r\n",stillMovingCounter);
        }
    }
    motorLeft.write(0);                 // stop the left motor
    encoderLeft.reset();                // set the encoder angle to 0
//  pc.printf("Left motor calibrated\r\n");

//this second part of the calibration moves the robot to its start position using feedback control.
    int calAngle = -1 ;                         
    while(counter <= 800){              // this while statement runs 800 times, and it runs at 200hz. this will make the robot move to the starting position in 4 seconds.
        if (work == true)  {            // the if statement in combination with the work boolean makes sure the loop runs at 200Hz
            int errorLeft  = errorCalculate(1,calAngle);            // calling some functions that will be explained at their definition to make the motor move in small steps to the starting position
            int errorRight = errorCalculate(2,calAngle);
            float inputLeft = PID_controller(errorLeft);
            float inputRight = PID_controller(errorRight);
            lowLevelMotorFunc(1,inputLeft);
            lowLevelMotorFunc(2,inputRight);
            counter++;
            calAngle = calAngle - 1;        // making the motor want to turn 1 step more again (in encoder steps)
            work = false;
        }
    }
    motorRight.write(0);        // when it is there it will stop the motors 
    motorLeft.write(0);
    encoderRight.reset();           // and the angles will be once again reset 
    encoderLeft.reset();
    
    return 0;      
}




double PID_controller(double error){
    static double error_integral = 0;
    static double error_prev = error; // initialization with this value only done once!
    static BiQuad LowPassFilter(0.0640, 0.1279, 0.0640, -1.1683, 0.4241);  
    double Kp = 0.015; //Waardes voor de PID controller using the Ziegler-Nicholson
    double Ki = 0.1;
    double Kd = 0.003;
    double Ts = 0.005; // Sample time in seconds  
    
    //Proportional part
    double u_p = Kp*error;

    //Integral part
    error_integral = error_integral + error * Ts;
    double u_i = Ki*error_integral  ;

    //Derivative part
    double error_derivative = (error - error_prev)/Ts;
    double filtered_error_derivative = LowPassFilter.step(error_derivative);
    double u_d = Kd * filtered_error_derivative;
    error_prev = error;

    //Sum of all errors
    return u_p + u_i + u_d;
}



void kinematics (float& Px, float& Py,float& q1, float& Endx, float& Endy, float& Kstukjex, float& Kstukjey, float xverp, float yverp, float& q5)   
{

    Px = Endx + Kstukjex + xverp;                                                                   //Calculation of the End-effectors x-position with displacement
    Py = Endy + Kstukjey + yverp;                                                                   //Calculation of the End-effectors y-position with displacement

    double pi = 3.141592653589793238462643383;                                                      //Definition of pi with a lot of decimals
    float Lb = 0.65;                                                                                //Distance between the motors
    float Lf = 0.46;                                                                                //Length of the forearms
    float Lu = 0.2;                                                                                 //Length of the upperarms
    float Lextra = 0.05;                                                                            //Length of extra segment
    float x = Lextra/Lf;                                                                            //Ratio of length of extra segment and the total length of the arm
    float A[2] = {Lb/2 , 0};                                                                        //Location of joint A
    float E[2] = {-Lb/2, 0};                                                                        //Location of joint E

// Inverse Kinematics
    float LengthAC = sqrt(pow(Endx-A[0],2) + pow(Endy - A[1],2));                                   //Length from joint A to the end-effector
    float LengthEC = sqrt(pow(Endx-E[0],2) + pow(Endy - E[1],2));                                   //Length from joint E to the end-effector

    float Alpha1 = acos((pow(Lu,2) - pow(Lf,2) + pow(LengthAC,2)) / (2*Lu*LengthAC));               //The angle between joint E,A and C, using the cosine rule
    float Beta1 = atan2(Endy,(A[0]-Endx));                                                          //The angle between joint A,B and C, using the atan2 function
    float Beta5 = acos((pow(Lu,2) - pow(Lf,2) + pow(LengthEC,2)) / (2*Lu*LengthEC));                //The angle between joint A,E and C, using the cosine rule
    float Alpha5 = atan2(Endy,(Endx-E[0]));                                                         //The angle between joint D,E and C, using the atan2 function

    q1 = pi - Alpha1 - Beta1;                                                                       //The new input angle
    q5 = Alpha5 + Beta5;                                                                            //The new input angle
    //printf("q1=%f q5=%f\r\n",q1,q5);

//Forward Kinematics
    float B[2] = {A[0] + Lu* cos(q1), A[1] + Lu * sin(q1)};                                         //The position of joint B
    float D[2] = {E[0] + Lu* cos(q5), E[1] + Lu * sin(q5)};                                         //The position of joint D
    float V[2] = {D[0] - B[0], D[1] - B[1]};                                                        //The vector V from joint B to D
    float H[2] = {0.5*(B[0]+D[0]),0.5*(B[1]+D[1])};                                                 //The position H positioned on half of the vector V
    float LengthV = sqrt(pow(V[0],2)+pow(V[1],2));                                                  //The length of vector V
    float LengthCh = sqrt(pow(Lf,2)-pow((0.5*LengthV),2));                                          //The length of position C to H

//End effector position (where the joints meet again.)

    float C[2] = {H[0] + (LengthCh/LengthV)*V[1], H[1] + (LengthCh/LengthV)*-V[0]};                 //The position of the end-effector, without extra segment. Calculated using the ratio between length V and CH, added to the position H
    Endx = C[0];                                                                                    //The x-position of the end-effector, without extra segment
    Endy = C[1];                                                                                    //The y-position of the end-effector, without extra segment

//nu moet extra kstukje erbij.

    float Vector[2] = {C[0]-D[0], C[1]-D[1]};                                                       //The vector from joint D to C
    float Kstukje[2] = {x*Vector[0],x*Vector[1]};                                                   //The extra segment, which is an extension of vector DC
    Kstukjex = Kstukje[0];                                                                          //The x-position of the extra segment
    Kstukjey = Kstukje[1];                                                                          //The y-position of the extra segment
    Endx = Px - Kstukjex;                                                                           //The end-effector's x-position without extra segment
    Endy = Py - Kstukjey;                                                                           //The end-effector's y-position without extra segment
}



void lowLevelMotorFunc(int whichMotor, float motorVel) {            //this function is used to make the motors move, you can choose between the left or the right motor and give it a velocity
    
    float motorRightSpeed;
    float motorLeftSpeed;
    
    if (whichMotor == 2) {                                          //2 is the right motor 1 is the left motor
        if (motorVel <= 0) {                                        //checing if the motor should turn left or right, and then setting the direction
            directionRight = 0;
        }
        else {
            directionRight = 1;
        }
        motorRightSpeed = abs(motorVel);                            // this acts as a limit on the speed of the motors, if the motors would have moved faster we would have had problems. 
        if (motorRightSpeed >=0.7) {
                motorRightSpeed = 0.7;
        }        
        motorRight.write(motorRightSpeed);                          // writes the pwm value to the motor
    }
    else if (whichMotor == 1) {                                     // same for the left motor.
        if (motorVel <= 0) {
            directionLeft = 0;
        }
        else {
            directionLeft = 1;
        }
        motorLeftSpeed = abs(motorVel);
        if (motorLeftSpeed >=0.7) {
                motorLeftSpeed = 0.7;
        }
        motorLeft.write(motorLeftSpeed);        
    }       
    
}
    
int errorCalculate(int whichEncoder, int desiredAngle) {        //this function calculates the error by comparing the current angle to the desired angle 
    int error;
    int currentAngle;
    
    if (whichEncoder == 1) {
        currentAngle = encoderLeft.getPulses();
    }
    else if (whichEncoder == 2) {
        currentAngle = encoderRight.getPulses();
    }
    error = desiredAngle - currentAngle;
    return error;                                               //and then returns the error in encoder counts
}


 