#ifndef MAIN
#define MAIN

// including all the header files of the libraries i need (if needed also my own header files but that is not needed because this is a relativly small projecdtd)
#include "MODSERIAL.h"
#include "QEI.h"
#include "mbed.h"
#include "HIDScope.h"
#include "BiQuad.h"
#include "stdlib.h"

// functions declerations for motor.cpp
int motorInitialize(void);           
int motorCalibrate(void);               
double PID_controller(double);          
void kinematics(float&, float&, float&, float&, float&, float&, float&, float, float, float&);
void lowLevelMotorFunc(int, float);
int errorCalculate(int, int);

// functions declerations for filter.cpp
void filter(void);
void spieren(void);
void initialize_filters();

//functions for main.cpp
void hertz(void);
void button_pressed1(void);

// very global variables and objects and so on 
extern MODSERIAL pc;
//extern HIDScope scope;



//Define objects / variables
extern AnalogIn    emg0;
extern AnalogIn    emg1;
extern AnalogIn    emg2;
extern InterruptIn button1;
extern InterruptIn button2; 
extern Ticker      filter_timer;
extern DigitalOut  led1;
extern DigitalOut  led2;
extern DigitalOut  led3;
extern double pi;
extern float q1;
extern float Endy;
extern float Endx;
extern float Px;
extern float Py;
extern float Kstukjex;
extern float Kstukjey;
extern float xverp;
extern float yverp;
extern float q5;
extern int differenceLeft;
extern int differenceRight;
extern float speedLeft;
extern float speedRight;
extern bool work;
extern BiQuadChain bqc1;
extern BiQuadChain bqc2;
extern BiQuadChain bqc3;
extern BiQuadChain bqc4;
extern double a1[];
extern double b1[];
extern double c1[];
extern double d1[];
extern double c2[];
extern double d2[];
extern int sample_counter;
extern int sample_counter2;
extern const int Size;
extern double array1[];
extern double array2[];
extern double sum1;
extern double sum2;
extern double avg1;
extern double avg2;
extern BiQuad HighPassFilter;
extern BiQuad NotchFilter;
extern BiQuad LowPassFilter;
extern BiQuad HighPassFilter2;
extern BiQuad NotchFilter2;
extern BiQuad LowPassFilter2;
extern bool directionSwitch;
extern int way;
extern double filtered_emg1;
extern double filtered_emg2;


#endif