#include "main.h"

//global object definition of pc connection for debugging purposes
MODSERIAL pc(USBTX,USBRX);

//Define objects
AnalogIn    emg0( A0 );
AnalogIn    emg1( A1 );
AnalogIn    emg2( A2 );
InterruptIn button1( D2 );
Ticker      filter_timer;
DigitalOut  led1(LED_RED);
DigitalOut  led2(LED_BLUE);
DigitalOut  led3(LED_GREEN);


//filter parameters
double b1[] = {0.0001551484234757206,0.0003102968469514411,0.0001551484234757206};
double a1[] = {-1.964460580205232,0.965081173899135};
double c1[] = {0.956543225556877,-1.913086451113754,0.956543225556877};
double d1[] = {-1.911197067426073,0.914975834801434};
double c2[] = {0.956543225556877, -1.913086451113754, 0.956543225556877};
double d2[] = {-1.911197067426073, 0.914975834801434};
int sample_counter = 0;
int sample_counter2 = 0;
const int Size = 1000;
double array1[Size];
double array2[Size];
double sum1;
double sum2;
double avg1;
double avg2;
double filtered_emg1;
double filtered_emg2;
int way;

//BiQuad Chain 1 included HighPass & Notch
BiQuadChain bqc1;
BiQuad HighPassFilter(c1[0], c1[1], c1[2], d1[0], d1[1]);
BiQuad NotchFilter(0.991103635646810,-1.603639368850131,0.991103635646810,-1.603639368850131,0.982207271293620);
//BiQuad Chain 2 included LowPass & Highpass2
BiQuadChain bqc2;
BiQuad LowPassFilter(b1[0], b1[1], b1[2], a1[0], a1[1]);
//BiQuad HighPassFilter2(c2[0], c2[1], c2[2], d2[0], d2[1]);
//BiQuad Chain 3 included HighPass & Notch
BiQuadChain bqc3;
BiQuad HighPassFilter2(c1[0], c1[1], c1[2], d1[0], d1[1]);
BiQuad NotchFilter2(0.991103635646810,-1.603639368850131,0.991103635646810,-1.603639368850131,0.982207271293620);
//BiQuad Chain 4 included LowPass & Highpass2
BiQuadChain bqc4;
BiQuad LowPassFilter2(b1[0], b1[1], b1[2], a1[0], a1[1]);
//BiQuad HighPassFilter2(c2[0], c2[1], c2[2], d2[0], d2[1]);

bool directionSwitch = true;    //boolean for the button state for the direction

void button_pressed1(void)      // function for the button state that will switch the direction
{
    directionSwitch = !directionSwitch;
}


//Kinematics parameters 
double pi = 3.141592653589793238462643383;      //pi with a lot of decimals
float q1 = 0.5*pi;                              //Input angle for the motor
float Endx = 0.000;                             //End-effector x-position without extra segment 
float Endy = 0.5255;                            //End-effector y-position without extra segment 
float Kstukjex = 0.0353;                        //Extra segment's x-position
float Kstukjey = 0.0353;                        //Extra segment's y-position
float Px=Endx+Kstukjex;                         //The real end-effector's x-position
float Py=Endy+Kstukjey;                         //The real end-effector's x-position
float xverp = 0;                                //Defintion of x-displacement of the end-effector
float yverp = 0;                                //Defintion of y-displacement of the end-effector
float q5 = 0.5*pi;                              //Input angle for the motor
int differenceLeft;
int differenceRight;
float speedLeft = 0;
float speedRight = 0;

//boolean, ticker and function to run the main loop at 200Hz
bool work = false;
Ticker loop;
void hertz(void){
    work = true;
}

// main function
int main() {                         
    pc.baud(115200);                        // set baud rate for connection with computer
    pc.printf("Hello World!\r\n");          // hello world statement to see if mbed responds
    loop.attach(&hertz,0.005);              // attatach a boolean to a ticker for a loop of 200 Hz

    bqc1.add( &HighPassFilter).add( &NotchFilter);      // initializes the filters
    bqc2.add( &LowPassFilter);
    // bqc2.add( &HighPassFilter2);
    bqc3.add( &HighPassFilter2).add( &NotchFilter2);
    bqc4.add( &LowPassFilter2);
    // bqc2.add( &HighPassFilter2);

    button1.rise(&button_pressed1);         // setting the interrupt for the button of the direction

    motorInitialize();                      // calls the motorinitialze function
    motorCalibrate();                       // calls the motorcalibrate function
    int   desiredAngleLeft;                 
    int   desiredAngleRight;
    
    filter_timer.attach(&filter, 0.002);    //Attach the 'sample' function to the timer 'sample_timer' this ensures that 'sample' is executed every... 0.002 seconds = 500 Hz

    while(true) {                           //main loop that runs forever
        if (work == true) {                 //if statement to make sure the loop runs at 200Hz
            spieren();                          
//          pc.printf("the way = %i \r\n", way);
            led1 = 1;
            led2 = 1;
            led3 = 1;
            if (way == 1) {                     // this is the if statement that handles the direction depending on what emg input there is (a swtich statment would maybe have been nicer)
                if(Px >= -0.073) {              // this condition makes sure the robot cant move out of its reach.
                    led1 = 1;                   // turns LEDS off
                    led2 = 1;
                    led3 = 1;
                    xverp = -0.00025;           // this is the displacemtn of the end effector which will be passed to the kinematics function later.
                    yverp = 0;                  // and of course also for the y axis 
                }
                else{
                    xverp = 0;
                    yverp = 0;   
                }
            }
            if (way == 2) {                     // same code, differnt direcdtion, still quite some optimization possible. ( all the else statments being the same and the leds being set to off all the time)
                if(Px <= 0.145) {
                    led1 = 1;
                    led2 = 1;
                    led3 = 1;
                    xverp = 0.00025;
                    yverp = 0;
                }
                else{
                    xverp = 0;
                    yverp = 0;   
                }
            }
            if(way == 3) {
                if(Py >= 0.3){
                    led1 = 1;
                    led2 = 1;
                    led3 = 1;
                    xverp = 0;
                    yverp = -0.00025;
                }
                else{
                    xverp = 0;
                    yverp = 0;   
                }
            }
            if(way == 4) {
                if(Py <= 0.53){
                    led1 = 1;
                    led2 = 1;
                    led3 = 1;
                    xverp = 0;
                    yverp = 0.00025;
                }
                else {
                    xverp = 0;
                    yverp = 0;   
                }
            }
            if(way == 5) {          // if there is no emg signal we need to make sure the end effector gets an active input of: "don't move" 
                xverp = 0;
                yverp = 0;
            }
            if(directionSwitch == true){            // this handles the LED to see if you are moving in the X or Y direction. 
                led1 = 0;
                }
            if(directionSwitch == false){
                led3 = 0;
                }
            

            kinematics(Px,Py,q1,Endx,Endy,Kstukjex,Kstukjey,xverp,yverp,q5);        // calls the kinematics function to get obtain the desired angles with the input of a linear displacement.
            float q1Encoder = (q1 - (0.5 * pi)) * 4200 / (2*pi);                    // radians to encoder counts
            float q5Encoder = -(q5 - (0.5 * pi)) * 4200 / (2*pi);
            desiredAngleLeft = static_cast<int>(q1Encoder);                         // float to int
            desiredAngleRight = static_cast<int>(q5Encoder);
            int errorLeft  = errorCalculate(1,desiredAngleLeft);                    // using the error calculate function to calculate the angle error in encoder counts
            int errorRight = errorCalculate(2,desiredAngleRight);               
            float inputLeft = PID_controller(errorLeft);                            // this error is then put into the pid controller which is tuned for our robot
            float inputRight = PID_controller(errorRight);
            lowLevelMotorFunc(1,inputLeft);                                         // and the output of the pid is inserted into the lowlevel motor function which makes the motors move in the right direction.
            lowLevelMotorFunc(2,inputRight);
            work = false;                                                           // sets timer boolean to false
        }
    }
}
