#include "mbed.h"
#include "EthernetInterface.h"
#include "Adafruit_SSD1306.h"

#define TOKEN "3252156354-fG0b1utXYAg5IqeJNMSJFlenx1rgSRXm5wgk21l"
//#define TOKEN "UserToken"

// an SPI sub-class that provides a constructed default
class I2CPreInit : public I2C
{
public:
    I2CPreInit(PinName sda, PinName scl) : I2C(sda, scl)
    {
        frequency(100000);
        start();
    };
};

I2CPreInit gI2C(PA_10,PA_9);
Adafruit_SSD1306_I2c gOled(gI2C,NC,0x78,64,128);


int main()
{
        int phy_link;
        printf("Wait a second...\r\n");
        //--------- Have to modify the mac address-------------
        uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x03, 0x04, 0x21}; 
        
        EthernetInterface eth;
        eth.init(mac_addr); //Use DHCP
            
        eth.connect();
        
        while(1){
                
            /* phy link */
            do{
                phy_link = eth.ethernet_link();
                printf("...");
                wait(2);
            }while(!phy_link);
            printf("\r\n");
                 
            printf("IP Address is %s\r\n", eth.getIPAddress());
              
            /* TCP socket connect */
            TCPSocketConnection sock;
            sock.connect("arduino-tweet.appspot.com", 80);
    
            printf("connected\r\n\r\n");
            
            /* typing message */        
            printf("typing twitter message :");
            
            char* message;
            scanf("%s",message);   
            printf("%s",message);
            printf("\r\n\r\n");
            
            int len = strlen(message);
            
            /* data length measure */
            char data_len[2]={0};
            int ten=0;
            int one=0;
            
            int length = len + sizeof(TOKEN) - 1 + 14;
            
            printf("length : %d\r\n\r\n",length);
            
            ten = length/10;
            one = length%10;
            data_len[1] = one + 48;
            data_len[0] = ten + 48;
        
            char *cmd1 = "POST http://arduino-tweet.appspot.com/update HTTP/1.0\r\nContent-Length:";
            char *cmd2 = data_len;
            char *cmd3 = "\r\n\r\ntoken=";
            char *cmd4 = TOKEN;
            char *cmd5 = "&status=";
            char *cmd6 = message;
            char *cmd7 = "\r\n";
    
            char send_data[1024];
            char buffer[1024] = {0};
            sprintf(send_data, "%s%s%s%s%s%s%s", cmd1, cmd2, cmd3, cmd4, cmd5, cmd6, cmd7);
    
            sock.send_all(send_data, sizeof(send_data)-1);
    
            printf("%s\r\n",send_data);
            printf("send message done\r\n");
    
            sock.receive(buffer, sizeof(buffer)-1);
    
            printf("%s\r\n",buffer);
            
            gOled.begin();
            gOled.printf("%s\r\n",message);
            gOled.display();
    
            wait(70.0);
            
            gOled.clearDisplay();
            
            //sock.close();
            //eth.disconnect();
            
    };

}
