#include "mbed.h"
#include "SDFileSystem.h"
#include "MPU9250.h"
#include "BMP280_SPI.h"
#include "GPS.h"

//SDFileSystem sd(p11, p12, p13, p15, "sd");
SDFileSystem sd(PB_15, PB_14, PB_13, PB_12, "sd");
DigitalOut led(PC_13);
GPS gps(PA_9, PA_10); // tx, rx
Serial xbee(PA_11,PA_12,38400);
SPI spi(PA_7, PA_6, PA_5);
mpu9250_spi imu(spi,PA_4);   //define the mpu9250 object
BMP280_SPI sensor(PA_7, PA_6, PA_5, PB_0);
Serial pc(PA_2,PA_3);

FILE *fp;

int main()
{
    int i=0;

    mkdir("/sd/data", 0777);

    fp = fopen("/sd/data/sdtest.csv", "w");
    if(fp == NULL) {
        error("Could not open file for write\r\n");
    }

    if(imu.init(1,BITS_DLPF_CFG_188HZ)) { //INIT the mpu9250
        pc.printf("\nCouldn't initialize MPU9250 via SPI!\r");
    }
    pc.printf("\nWHOAMI=0x%2x\n\r",imu.whoami()); //output the I2C address to know if SPI is working, it should be 104
    wait(1);
    pc.printf("Gyro_scale=%u\n\r",imu.set_gyro_scale(BITS_FS_2000DPS));    //Set full scale range for gyros
    wait(1);
    pc.printf("Acc_scale=%u\n\r",imu.set_acc_scale(BITS_FS_16G));          //Set full scale range for accs
    wait(1);
    pc.printf("AK8963 WHIAM=0x%2x\n\r",imu.AK8963_whoami());
    wait(0.1);
    imu.AK8963_calib_Magnetometer();

    fprintf(fp,"MPU9250_data, , , , , , , , , ,");
    fprintf(fp,"BMP280_data, ,");
    fprintf(fp,"GMT: ,N.Lat: ,E.Lng: ,stat: ,satnum: ,\r\n");
    fprintf(fp,"MPU9250_data, , , , , , , , , ,");
    fprintf(fp,"BMP280_data, ,");
    fprintf(fp,"GMT: ,N.Lat: ,E.Lng: ,stat: ,satnum: ,\r\n");

    while (i<30) {
        wait(0.1);
        /*
        imu.read_temp();
        imu.read_acc();
        imu.read_rot();
        imu.AK8963_read_Magnetometer();
        */
        imu.read_all();
        pc.printf("%10.3f,%10.3f,%10.3f,%10.3f,%10.3f,%10.3f,%10.3f,%10.3f,%10.3f,%10.3f\n\r",
                  imu.Temperature,
                  imu.gyroscope_data[0],
                  imu.gyroscope_data[1],
                  imu.gyroscope_data[2],
                  imu.accelerometer_data[0],
                  imu.accelerometer_data[1],
                  imu.accelerometer_data[2],
                  imu.Magnetometer[0],
                  imu.Magnetometer[1],
                  imu.Magnetometer[2]
                 );
        fprintf(fp,"%10.3f,%10.3f,%10.3f,%10.3f,%10.3f,%10.3f,%10.3f,%10.3f,%10.3f,%10.3f,",
                imu.Temperature,
                imu.gyroscope_data[0],
                imu.gyroscope_data[1],
                imu.gyroscope_data[2],
                imu.accelerometer_data[0],
                imu.accelerometer_data[1],
                imu.accelerometer_data[2],
                imu.Magnetometer[0],
                imu.Magnetometer[1],
                imu.Magnetometer[2]
               );

        pc.printf("%2.2f degC, %04.2f hPa\n\r", sensor.getTemperature(), sensor.getPressure());
        fprintf(fp,"%2.2f , %04.2f ,", sensor.getTemperature(), sensor.getPressure());

        //accelerometer.read_mg_data(readings);
        //pc.printf("x=%f, y=%f, z=%f\r\n",readings[0],readings[1],readings[2]);
        //fprintf(fp,"%f, %f, %f,",readings[0],readings[1],readings[2]);

        pc.printf("世界標準時:%02dh%02dm%02ds 北緯:%.8f 東経:%.8f 状態:%d 使用衛星数:%d\r\n",
                  gps.g_hour, gps.g_min, gps.g_sec, gps.g_hokui, gps.g_tokei, gps.rlock, gps.stlgt);
        fprintf(fp,"%02dh%02dm%02ds ,%.8f ,%.8f ,%d ,%d\r\n",
                gps.g_hour, gps.g_min, gps.g_sec, gps.g_hokui, gps.g_tokei, gps.rlock, gps.stlgt);

        led=!led;
        i++;
    }
    fclose(fp);
}
