#ifndef USB_HID_KEYBOARD_H
#define USB_HID_KEYBOARD_H

/* Placed in the public domain by its author, Ian Harvey */

/* Modifier key bit values */

#define MODBIT_LEFT_CTRL        0x01
#define MODBIT_LEFT_SHIFT       0x02
#define MODBIT_LEFT_ALT         0x04
#define MODBIT_LEFT_GUI         0x08
#define MODBIT_RIGHT_CTRL       0x10
#define MODBIT_RIGHT_SHIFT      0x20
#define MODBIT_RIGHT_ALT        0x40
#define MODBIT_RIGHT_GUI        0x80

/* From USB HID Usage Tables Version 1.12, Section 10 */

#define KEY_NONE            0
#define KEY_ErrorRollOver   1
#define KEY_POSTFail        2
#define KEY_ErrorUndefined  3
#define KEY_A   4
#define KEY_B   5
#define KEY_C   6
#define KEY_D   7
#define KEY_E   8
#define KEY_F   9
#define KEY_G   10
#define KEY_H   11
#define KEY_I   12
#define KEY_J   13
#define KEY_K   14
#define KEY_L   15
#define KEY_M   16
#define KEY_N   17
#define KEY_O   18
#define KEY_P   19
#define KEY_Q   20
#define KEY_R   21
#define KEY_S   22
#define KEY_T   23
#define KEY_U   24
#define KEY_V   25
#define KEY_W   26
#define KEY_X   27
#define KEY_Y   28
#define KEY_Z   29
#define KEY_1   30
#define KEY_2   31
#define KEY_3   32
#define KEY_4   33
#define KEY_5   34
#define KEY_6   35
#define KEY_7   36
#define KEY_8   37
#define KEY_9   38
#define KEY_0   39

#define KEY_ENTER       40
#define KEY_ESC         41
#define KEY_BACKSPACE   42
#define KEY_TAB         43
#define KEY_SPACE       44
#define KEY_MINUS       45 /* And underscore */
#define KEY_EQUALS      46 /* And plus */
#define KEY_OPEN_SQUARE 47 /* And open-curly-bracket */
#define KEY_CLOSE_SQUARE    48 /* And close-curly-bracket */
#define KEY_BACKSLASH   49
#define KEY_HASH_TILDE  50
#define KEY_SEMICOLON   51
#define KEY_SINGLE_QUOTE    52
#define KEY_BACKTICK_TILDE  53
#define KEY_COMMA       54 /* And less-than */
#define KEY_PERIOD      55 /* And greater-than */
#define KEY_SLASH       56 /* And question-mark */
#define KEY_CAPS_LOCK   57

#define KEY_F1          58
#define KEY_F2          59
#define KEY_F3          60
#define KEY_F4          61
#define KEY_F5          62
#define KEY_F6          63
#define KEY_F7          64
#define KEY_F8          65
#define KEY_F9          66
#define KEY_F10         67
#define KEY_F11         68
#define KEY_F12         69

#define KEY_PRINT_SCREEN    70
#define KEY_SCROLL_LOCK     71
#define KEY_PAUSE       72
#define KEY_INSERT      73
#define KEY_HOME        74
#define KEY_PAGE_UP     75
#define KEY_DELETE      76 /* i.e. forward delete */
#define KEY_END         77
#define KEY_PAGE_DOWN   78
#define KEY_RIGHT_ARROW 79
#define KEY_LEFT_ARROW  80
#define KEY_DOWN_ARROW  81
#define KEY_UP_ARROW    82

/* TODO: keypad codes */

#define KEY_LEFT_CTRL       0xE0
#define KEY_LEFT_SHIFT      0xE1
#define KEY_LEFT_ALT        0xE2
#define KEY_LEFT_GUI        0xE3
#define KEY_RIGHT_CTRL      0xE4
#define KEY_RIGHT_SHIFT     0xE5
#define KEY_RIGHT_ALT       0xE6
#define KEY_RIGHT_GUI       0xE7

#define KEY_MODIFIERS_START 0xE0
#define KEY_MODIFIERS_END   0xE7
#define IS_MODIFIER(key) ((key) >= KEY_MODIFIERS_START && (key) <= KEY_MODIFIERS_END)
#define MODIFIER_BIT(key) (1 << ((key)-KEY_MODIFIERS_START))



#endif /* USB_HID_KEYBOARD_H */
#ifndef USB_HID_KEYBOARD_H
#define USB_HID_KEYBOARD_H

/* Modifier key bit values */

#define MODBIT_LEFT_CTRL        0x01
#define MODBIT_LEFT_SHIFT       0x02
#define MODBIT_LEFT_ALT         0x04
#define MODBIT_LEFT_GUI         0x08
#define MODBIT_RIGHT_CTRL       0x10
#define MODBIT_RIGHT_SHIFT      0x20
#define MODBIT_RIGHT_ALT        0x40
#define MODBIT_RIGHT_GUI        0x80

/* From USB HID Usage Tables Version 1.12, Section 10 */

#define KEY_NONE            0
#define KEY_ErrorRollOver   1
#define KEY_POSTFail        2
#define KEY_ErrorUndefined  3
#define KEY_A   4
#define KEY_B   5
#define KEY_C   6
#define KEY_D   7
#define KEY_E   8
#define KEY_F   9
#define KEY_G   10
#define KEY_H   11
#define KEY_I   12
#define KEY_J   13
#define KEY_K   14
#define KEY_L   15
#define KEY_M   16
#define KEY_N   17
#define KEY_O   18
#define KEY_P   19
#define KEY_Q   20
#define KEY_R   21
#define KEY_S   22
#define KEY_T   23
#define KEY_U   24
#define KEY_V   25
#define KEY_W   26
#define KEY_X   27
#define KEY_Y   28
#define KEY_Z   29
#define KEY_1   30
#define KEY_2   31
#define KEY_3   32
#define KEY_4   33
#define KEY_5   34
#define KEY_6   35
#define KEY_7   36
#define KEY_8   37
#define KEY_9   38
#define KEY_0   39

#define KEY_ENTER       40
#define KEY_ESC         41
#define KEY_BACKSPACE   42
#define KEY_TAB         43
#define KEY_SPACE       44
#define KEY_MINUS       45 /* And underscore */
#define KEY_EQUALS      46 /* And plus */
#define KEY_OPEN_SQUARE 47 /* And open-curly-bracket */
#define KEY_CLOSE_SQUARE    48 /* And close-curly-bracket */
#define KEY_BACKSLASH   49
#define KEY_HASH_TILDE  50
#define KEY_SEMICOLON   51
#define KEY_SINGLE_QUOTE    52
#define KEY_BACKTICK_TILDE  53
#define KEY_COMMA       54 /* And less-than */
#define KEY_PERIOD      55 /* And greater-than */
#define KEY_SLASH       56 /* And question-mark */
#define KEY_CAPS_LOCK   57

#define KEY_F1          58
#define KEY_F2          59
#define KEY_F3          60
#define KEY_F4          61
#define KEY_F5          62
#define KEY_F6          63
#define KEY_F7          64
#define KEY_F8          65
#define KEY_F9          66
#define KEY_F10         67
#define KEY_F11         68
#define KEY_F12         69

#define KEY_PRINT_SCREEN    70
#define KEY_SCROLL_LOCK     71
#define KEY_PAUSE       72
#define KEY_INSERT      73
#define KEY_HOME        74
#define KEY_PAGE_UP     75
#define KEY_DELETE      76 /* i.e. forward delete */
#define KEY_END         77
#define KEY_PAGE_DOWN   78
#define KEY_RIGHT_ARROW 79
#define KEY_LEFT_ARROW  80
#define KEY_DOWN_ARROW  81
#define KEY_UP_ARROW    82

/* TODO: keypad codes */

#define KEY_LEFT_CTRL       0xE0
#define KEY_LEFT_SHIFT      0xE1
#define KEY_LEFT_ALT        0xE2
#define KEY_LEFT_GUI        0xE3
#define KEY_RIGHT_CTRL      0xE4
#define KEY_RIGHT_SHIFT     0xE5
#define KEY_RIGHT_ALT       0xE6
#define KEY_RIGHT_GUI       0xE7

#define KEY_MODIFIERS_START 0xE0
#define KEY_MODIFIERS_END   0xE7
#define IS_MODIFIER(key) ((key) >= KEY_MODIFIERS_START && (key) <= KEY_MODIFIERS_END)
#define MODIFIER_BIT(key) (1 << ((key)-KEY_MODIFIERS_START))



#endif /* USB_HID_KEYBOARD_H */
#ifndef USB_HID_KEYBOARD_H
#define USB_HID_KEYBOARD_H

/* Modifier key bit values */

#define MODBIT_LEFT_CTRL        0x01
#define MODBIT_LEFT_SHIFT       0x02
#define MODBIT_LEFT_ALT         0x04
#define MODBIT_LEFT_GUI         0x08
#define MODBIT_RIGHT_CTRL       0x10
#define MODBIT_RIGHT_SHIFT      0x20
#define MODBIT_RIGHT_ALT        0x40
#define MODBIT_RIGHT_GUI        0x80

/* From USB HID Usage Tables Version 1.12, Section 10 */

#define KEY_NONE            0
#define KEY_ErrorRollOver   1
#define KEY_POSTFail        2
#define KEY_ErrorUndefined  3
#define KEY_A   4
#define KEY_B   5
#define KEY_C   6
#define KEY_D   7
#define KEY_E   8
#define KEY_F   9
#define KEY_G   10
#define KEY_H   11
#define KEY_I   12
#define KEY_J   13
#define KEY_K   14
#define KEY_L   15
#define KEY_M   16
#define KEY_N   17
#define KEY_O   18
#define KEY_P   19
#define KEY_Q   20
#define KEY_R   21
#define KEY_S   22
#define KEY_T   23
#define KEY_U   24
#define KEY_V   25
#define KEY_W   26
#define KEY_X   27
#define KEY_Y   28
#define KEY_Z   29
#define KEY_1   30
#define KEY_2   31
#define KEY_3   32
#define KEY_4   33
#define KEY_5   34
#define KEY_6   35
#define KEY_7   36
#define KEY_8   37
#define KEY_9   38
#define KEY_0   39

#define KEY_ENTER       40
#define KEY_ESC         41
#define KEY_BACKSPACE   42
#define KEY_TAB         43
#define KEY_SPACE       44
#define KEY_MINUS       45 /* And underscore */
#define KEY_EQUALS      46 /* And plus */
#define KEY_OPEN_SQUARE 47 /* And open-curly-bracket */
#define KEY_CLOSE_SQUARE    48 /* And close-curly-bracket */
#define KEY_BACKSLASH   49
#define KEY_HASH_TILDE  50
#define KEY_SEMICOLON   51
#define KEY_SINGLE_QUOTE    52
#define KEY_BACKTICK_TILDE  53
#define KEY_COMMA       54 /* And less-than */
#define KEY_PERIOD      55 /* And greater-than */
#define KEY_SLASH       56 /* And question-mark */
#define KEY_CAPS_LOCK   57

#define KEY_F1          58
#define KEY_F2          59
#define KEY_F3          60
#define KEY_F4          61
#define KEY_F5          62
#define KEY_F6          63
#define KEY_F7          64
#define KEY_F8          65
#define KEY_F9          66
#define KEY_F10         67
#define KEY_F11         68
#define KEY_F12         69

#define KEY_PRINT_SCREEN    70
#define KEY_SCROLL_LOCK     71
#define KEY_PAUSE       72
#define KEY_INSERT      73
#define KEY_HOME        74
#define KEY_PAGE_UP     75
#define KEY_DELETE      76 /* i.e. forward delete */
#define KEY_END         77
#define KEY_PAGE_DOWN   78
#define KEY_RIGHT_ARROW 79
#define KEY_LEFT_ARROW  80
#define KEY_DOWN_ARROW  81
#define KEY_UP_ARROW    82

/* TODO: keypad codes */

#define KEY_LEFT_CTRL       0xE0
#define KEY_LEFT_SHIFT      0xE1
#define KEY_LEFT_ALT        0xE2
#define KEY_LEFT_GUI        0xE3
#define KEY_RIGHT_CTRL      0xE4
#define KEY_RIGHT_SHIFT     0xE5
#define KEY_RIGHT_ALT       0xE6
#define KEY_RIGHT_GUI       0xE7

#define KEY_MODIFIERS_START 0xE0
#define KEY_MODIFIERS_END   0xE7
#define IS_MODIFIER(key) ((key) >= KEY_MODIFIERS_START && (key) <= KEY_MODIFIERS_END)
#define MODIFIER_BIT(key) (1 << ((key)-KEY_MODIFIERS_START))



#endif /* USB_HID_KEYBOARD_H */
