#pragma once

#include "mbed.h"
#include "CRC16.h"
#include <iostream>       // std::cout
#include <string>         // std::string
#include <bitset>         // std::bitset

DigitalOut data(p26); //Data

enum states
{
    INIT_STATE      = 0,
    PREAMBULE       = 1,
    START           = 2,
    ENTETE          = 3,
    CHARGE_UTILE    = 4,
    CONTROLE        = 5,
    END             = 6
};

int state;
int cntState;
bool nextBit;
bitset<16> buffer;
bitset<640> chargeUtile;
int LENGTH_CHARGE_UTILE_BIT;
int LENGTH_CHARGE_UTILE_BYTE;
char c_chargeUtile[80];
unsigned short CRC_Calculated;
unsigned short CRC_Received;
bool messageReady;
CRC16 *m_crc;

Serial pc(USBTX, USBRX);

bool tclock;
bitset<696> toEncodeTest;
int pos;

void timer2_init(void);
int manchester_encode(bitset<696> toEncode);
int manchester_decode();
extern "C" void TIMER2_IRQHandler (void);
bool analyze_state(bool bit);