#include "main.h"

int main()
{
    tclock = 1;
    pos = 0;
    
    state = INIT_STATE;
    m_crc = new CRC16();
    messageReady = false;
    
    
    pc.printf("\n");
    pc.printf("\n");
    pc.printf("\n");
    pc.printf("\n");
    pc.printf("\n");
    pc.printf("\n");
    pc.printf("\n");
    pc.printf("\n");
    
    bitset<200> testMEF (string("0101010101111110000000000010000001000001010011000100110001001111001001001101011001111110"));
    
    for (int i = 87; i >= 0; i--)
    {    
        analyze_state(testMEF[i]);
    }
    
    if(messageReady)
    {
        for (int i = 0; i < LENGTH_CHARGE_UTILE_BYTE; i++)
            pc.printf("%c",c_chargeUtile[i]);
    }
    //toEncodeTest = bitset<696>(string("00011101010011"));
    
    //pc.printf("Test");
    
    //timer2_init();
    
    while(1)
    {
    }
}

void timer2_init(void)
{
    LPC_SC->PCLKSEL1 |=1<<12;       //pclk = cclk timer2
    LPC_SC->PCONP |=1<<22;          //timer2 power on
    LPC_TIM2->MR0 = 9600000;        //100 msec
    LPC_TIM2->MCR = 3;              //interrupt and reset control
                                    //3 = Interrupt & reset timer2 on match
                                    //1 = Interrupt only, no reset of timer0
    LPC_TIM2->EMR =2<<4;             //EMC0 = 10 (Toogle)
    NVIC_EnableIRQ(TIMER2_IRQn);    //enable timer2 interrupt
    LPC_TIM2->TCR = 1;              //enable Timer2
}

void timer3_init(void)
{
    LPC_SC->PCLKSEL1 |=1<<12;       //pclk = cclk timer2
    LPC_SC->PCONP |=1<<22;          //timer2 power on
    LPC_TIM2->MR0 = 9600000;        //100 msec
    LPC_TIM2->MCR = 3;              //interrupt and reset control
                                    //3 = Interrupt & reset timer2 on match
                                    //1 = Interrupt only, no reset of timer0
    LPC_TIM2->EMR =2<<4;             //EMC0 = 10 (Toogle)
    NVIC_EnableIRQ(TIMER2_IRQn);    //enable timer2 interrupt
    LPC_TIM2->TCR = 1;              //enable Timer2
}


bool analyze_state(bool bit)
{
    switch(state)
    {
       case INIT_STATE:
            
            pc.printf("INIT_STATE\t");
            
            if (bit == 0)
            {
                state = PREAMBULE;
                nextBit = 1;
                cntState = 0;
            }
            
            break;
            
        case PREAMBULE:
        
            pc.printf("PREAMBULE\t");
            if (bit == nextBit && cntState < 6)
            {
                nextBit = !nextBit;
                cntState++;
            }
            else if (bit == nextBit && cntState == 6)
            {
                state = START;
                cntState = 0;
                nextBit = 0;
            }
            else
            {
                state = INIT_STATE;
            }
            
            break;
            
        case START:
        
            pc.printf("START\t");
            
            if(cntState == 0 && bit == nextBit)
            {
                nextBit = 1;
                cntState++;
            }
            else if (cntState < 6 && bit == nextBit)
            {
                cntState++;
            }
            else if (cntState == 6 && bit == nextBit)
            {
                nextBit = 0;
                cntState++;
            }
            else if (cntState == 7 && bit == nextBit)
            {
                state = ENTETE;
                cntState = 0;
                nextBit = 0;
            }
            else
            {
                state = INIT_STATE;
            }
            
            break;
           
        case ENTETE:
        
            if(cntState < 7 && nextBit == 0)
            {
                pc.printf("TEST1: %i \t", cntState);
                cntState++;
                
            }
            else if (cntState == 7 && nextBit == 0)
            {
                pc.printf("TEST2: %i \t", cntState);
                nextBit = 1;
            }
            else if (nextBit == 1 && cntState > 0)
            {
                pc.printf("TEST3: %i \t", cntState);
                buffer.set(cntState, bit);
                cntState--;
            }
            else if (nextBit == 1 && cntState == 0)
            { 
                buffer.set(cntState, bit);
                state = CHARGE_UTILE;
                LENGTH_CHARGE_UTILE_BIT = (int)(buffer.to_ulong());
                
                cntState = LENGTH_CHARGE_UTILE_BIT - 1;
            }
            else
            {
                state = INIT_STATE;
            }
            
            break;
           
        case CHARGE_UTILE:
            
            pc.printf("CHARGE UTILE\t");
            
            if (cntState > 0)
            {
               chargeUtile.set(cntState, bit); 
               cntState--;
            }
            else if (cntState == 0)
            {
                chargeUtile.set(cntState, bit); 
                cntState = 0;
                state = CONTROLE;
                nextBit = 0;
            }
            else
            {
                state = INIT_STATE;
            }
            
            break;
           
        case CONTROLE:
            
            if(nextBit == 0)
            {
                LENGTH_CHARGE_UTILE_BYTE = LENGTH_CHARGE_UTILE_BIT / 8;
                
                for (int i = 0; i < LENGTH_CHARGE_UTILE_BIT; i++)
                {
                    pc.printf("%i", (chargeUtile[i] & 0x1));
                    if (i % 8 == 0)
                        c_chargeUtile[i / 8] = (chargeUtile[i] << 7) | (chargeUtile[i + 1] << 6) | (chargeUtile[i + 2] << 5) | (chargeUtile[i + 3] << 4) | (chargeUtile[i + 4] << 3) | (chargeUtile[i + 5] << 2) | (chargeUtile[i + 6] << 1) | (chargeUtile[i + 7] << 0);
                }
                
                CRC_Calculated = m_crc->calculateCRC16(c_chargeUtile, LENGTH_CHARGE_UTILE_BYTE);
                
                pc.printf("CRC Calculated: %hu\t", CRC_Calculated);
                
                nextBit = 1;
                cntState = 14;
                buffer.reset();
                buffer.set(15, bit);
            }
            else if (nextBit == 1 && cntState > 0)
            {
                buffer.set(cntState, bit);
                cntState--;
            }
            else if (nextBit == 1 && cntState == 0)
            {
                buffer.set(cntState, bit);
                CRC_Received = (unsigned short)buffer.to_ulong();
                
                pc.printf("CRC Received: %hu\t", CRC_Received);
                
                if (CRC_Received != CRC_Calculated)
                {
                    state = END;
                    nextBit = 0;
                    cntState = 0;
                }
                else
                {
                    state = INIT_STATE;
                }
            }
            else
            {
                state = INIT_STATE;
            }
            
            break;
           
        case END:
        
            if (nextBit == 0 && nextBit == bit && cntState == 0)
            {
                nextBit = 1;
                cntState++;
            }
            else if (nextBit == 1 && nextBit == bit && cntState < 6)
            {
                cntState++;
            }
            else if (nextBit == 1 && nextBit == bit && cntState == 6)
            {
                nextBit = 0;
                cntState++;
            }
            else if (nextBit == 0 && nextBit == bit && cntState == 7)
            {
                messageReady = true;
                state = INIT_STATE;
            }
            else
            {
                state = INIT_STATE;
                messageReady = false;
            }
        
        break;
    }
    
    return 1;
}

extern "C" void TIMER2_IRQHandler (void)
{
    if ((LPC_TIM2->IR & 0x01) == 0x01)   // if MR0 interrupt, proceed
    {
        LPC_TIM2->IR |= 1 << 0;         // Clear MR0 interrupt flag
        
        tclock = !tclock;
        
        if (pos < 14)
        {            
            LPC_TIM2->EMR = (toEncodeTest[pos] == tclock);
            pc.printf("%i", (toEncodeTest[pos] == tclock));
            if (tclock)
                pos++;
        }
    }
}

extern "C" void TIMER3_IRQHandler (void)
{
    if ((LPC_TIM3->IR & 0x01) == 0x01)   // if MR0 interrupt, proceed
    {
        LPC_TIM3->IR |= 1 << 0;         // Clear MR0 interrupt flag
        
        tclock = !tclock;
        
        if (pos < 14)
        {            
            LPC_TIM2->EMR = (toEncodeTest[pos] == tclock);
            pc.printf("%i", (toEncodeTest[pos] == tclock));
            if (tclock)
                pos++;
        }
    }
}