 // change this to 1 to output messages to LCD instead of serial
#define logMessage printf
#define MQTTCLIENT_QOS2 1

#include <string>
#include "mbed.h"
#include "easy-connect.h"
#include "MQTTNetwork.h"
#include "MQTTmbed.h"
#include "MQTTClient.h"
#include "TCPSocket.h"
//#include "DHT22.h"
#include "DHT_2.h"

#define WIFI_HW_RESET_PIN D4

#define MQTT_BROKER_ADDR "192.168.0.8"
#define MQTT_BROKER_PORT 1883

DigitalOut wifiHwResetPin(WIFI_HW_RESET_PIN);
DigitalOut led2(LED2);
DHT sensor(D7,DHT22);
Serial pc(USBTX, USBRX, 115200);
volatile bool flag = false;
Mutex mqttMtx;
char* topic1 = "LED";
char* topic2 = "TEMPER";
char* topic3 = "LEDS";

void messageArrived(MQTT::MessageData& md)
{
  MQTT::Message &message = md.message;
//  logMessage("Message arrived: qos %d, retained %d, dup %d, packetid %d\r\n",
//  message.qos, message.retained, message.dup, message.id);
  logMessage("Payload %.*s\r\n", message.payloadlen, (char*)message.payload);
 
  char fwdTarget = ((char *)message.payload)[0];
  switch(fwdTarget)
  {
  case '0': // turn off
    led2 = 0;
    break;
  case '1': //turn on
    led2 = 1;
    break;
  case '2': //LED status
    flag = true;
    break;
  default:
    pc.printf("Unknown MQTT message\n");
    break;
  }
}
int main(int argc, char* argv[])
{       //network setting
      float version = 0.5;
      pc.baud(115200);
      logMessage("MQTT example: version is %.2f\r\n", version);
      wait(0.2); //delay startup
      pc.printf("Resetting ESP8266 Hardware...\r\n");
      pc.printf("Attempting to connect to access point...\r\n");
     
      NetworkInterface* network = easy_connect(true);
        if (!network) {
        pc.printf("Error in east connection\r\n");
        return -1;
        }
 
       MQTTNetwork mqttNetwork(network);
       MQTT::Client<MQTTNetwork, Countdown> client(mqttNetwork);
       logMessage("Connecting to %s:%d\r\n", MQTT_BROKER_ADDR, MQTT_BROKER_PORT);
       int rc = mqttNetwork.connect(MQTT_BROKER_ADDR, MQTT_BROKER_PORT);
       if (rc != 0)
          logMessage("rc from TCP connect is %d\r\n", rc);
        
        
        MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
        data.MQTTVersion = 3;
        data.clientID.cstring = "mbed-jcm";
        data.username.cstring = "user-jcm";
        data.password.cstring = "testpassword";
        if ((rc = client.connect(data)) != 0)
        logMessage("rc from MQTT connect is %d\r\n", rc);
        if ((rc = client.subscribe(topic1, MQTT::QOS0, messageArrived)) != 0)
        logMessage("rc from MQTT subscribe is %d\r\n", rc);

        float c = 0;
        int error = 0;
        int count =0;
        pc.printf("starting to read temperature...\r\n");
        
        while(1){
            Thread::wait(1000);
            char buf[100];

            error = sensor.readData();
            
            if (count == 5) {
                pc.printf("5 secs over!");  
                pc.printf("Publish: TEMPER\r\n");
                if (0 == error) {
                    c   = sensor.ReadTemperature(CELCIUS);
                    printf("Temperature: %.1f\r\n", c);
                } else if(error == 6){
                    printf("CheckSum Error\r\n");

                sprintf(buf, "%3.1f", c);
                message.qos = MQTT::QOS2;
                message.retained = false;
                message.dup = false;
                message.payload = (void*)buf;
                message.payloadlen = strlen(buf)+1;
                mqttMtx.lock();
                rc = client.publish(topic2, message);
                mqttMtx.unlock();  
            
                count = 0;
                }
            if(!client.isConnected())
                NVIC_SystemReset(); // soft reset
                 
            client.yield(10);
            count++;
            pc.printf("%d\r\n",count); 

            }
    }
    
    return 0;
}



