#include "mbed.h"

#define Button1 p14

void nibbleleds(int);  //  funktionsprototypen
int laufLicht(bool,int, int);
void printb(uint8_t x);

BusOut myleds(LED1,LED2,LED3,LED4);   // 4leds zu bus zusammenfügen
DigitalIn button(Button1);            // BTN. 1 als input


const int INIT=3;

int main() {
    
    int anz, anzahl;
    uint8_t value=INIT;
    
    anzahl=laufLicht(true, 400, anz=0);
    
    
    
    nibbleleds(value);   // Nibbleleds_Funktion aufrufen und wert von value übergeben
    
    while(1) {      
    }
}

void nibbleleds(int value){
    myleds=value%16;             //value=3 modulo 16 ist 0 => leds dunkel
    }
    
int laufLicht(bool richtung, int time, int &anz){
    int i;
    
    uint8_t lauf=0x8;
    
    if(!richtung){       //.. wenn  richtung == false....
        lauf=0x08;       // ...setze lauf auf 8.
        }
        
    while(1){
        nibbleleds(lauf&0x0F);
        
        if(richtung){
            lauf=lauf<<1;    // wert von lauf verdoppeln
            if(lauf>8){      // wenn wert von lauf >8...
                lauf=0x01;    // dann setze lauf auf 1
            }    
        }
        else{
            lauf=lauf>>1;    // sonst wert von lauf halbieren
            if(lauf==0){      // wenn wert von lauf 0 ist,
               lauf=0x08;     // ..setze lauf auf 8
            }
        }
        
        if(button){        //wenn button == high...
            break;         // .... verlasse lauflicht-Schleife
            }  
            
        wait_ms(time);     // warten wert von time in mS
        anz++;              // zähler für schleifendurchläufe um eins erhöhen
        }
        return anz;         // Funktion verlassen und wert von anz zurueckgeben..      
    }
    
