
/*
 * This program blinks a led but this time we will show you
 * how to use the write function to manipulate the led state
 * according to a variable value
 *
 */
 
#include "mbed.h"
#include "Hotboards_leds.h"

//bitRead macro taken from arduino
#define bitRead( var, bit )           (((var) >> (bit)) & 0x01)

Hotboards_leds led( PA_5 );

uint8_t counter;

int main()
{
    while(1)
    {
        //The led will blink because we are writing the LSB
        //of the variable counter which on each iteration
        //is incremented by 1.
        led.write( bitRead( counter , 0 ) );
        wait_ms( 200 );
        counter ++;
    }
}
