
/* 
 * On this example we will show how to manipulate your leds
 * in different ways; the first 4 and the following 3 are
 * grouped into a bus each one and manipulated individually, 
 * and the last 1 is alone and manipulated individually.
 *
 * Connections:
 *
 * PA_5 --- led0 \
 * PA_6 --- led1  > leds
 * PA_7 --- led2 /
 * PB_6 --- led3 |
 *
 * PC_7 --- led4 \
 * PA_9 --- led5  > leds765
 * PA_8 --- led6 /
 *
 * PB_10 --- led8 > led8
 *
 */

#include "mbed.h"
#include "Hotboards_leds.h"

//Creates a bus with 4 leds
Hotboards_leds leds( PB_6 , PA_7 , PA_6 , PA_5 );
//Creates a bus with 3 leds that will be manipulated individually
Hotboards_leds leds765( PA_8 , PA_9 , PC_7 );
//Creates a single led on pin PB_10
Hotboards_leds led8( PB_10 );

uint8_t counter;

int main()
{
    counter = 0;
    while(1)
    {
        //Turns ON leds 5, 6 & 7, at the same time
        leds765.turnOn( 0 );
        leds765.turnOn( 1 );
        leds765.turnOn( 2 );
        wait_ms( 200 );
        //Turns OFF leds 5, 6 & 7, at the same time
        leds765.turnOff( 0 );
        leds765.turnOff( 1 );
        leds765.turnOff( 2 );
        wait_ms( 200 );
        //Toggle led numer 8
        led8.toggle( );
        //Writes the 4 LSB of variable counter on leds 1, 2, 3 & 4
        leds.write( counter );
        counter ++;
    }
}
