#include "mbed.h"
#include <string>

int rxCount = 0;
int DataAvailable = 0;
char rxbuff[128];
char txbuff[64];
char data[128];
char cmdbuff[32];
int  linkID;
int  ipdLen;
char type[16];

DigitalOut led(LED1);        // led de usuario en la tarjeta nucleo
DigitalOut led1(PB_14);      // led1 a controlar
DigitalOut led2(PB_15);      // led 2 a controlar

Timer tmr1;

Serial wifi(PC_10,PC_11);   // Puerto serial para comunicar con modulo WIFI
Serial pc(USBTX,USBRX);     // Puerto serial para comunicar con la pc

// prototipos de funciones
//void webServerInit(void);
//void reply(int tOut);
//void WifiCmd(void);

// interrupcion serial usada para recibir datos desde modulo wifi
void sISR() 
{    
    while (wifi.readable()) 
    {
      rxbuff[rxCount] = wifi.getc(); // dato recibido se almacena en rxbuff
      pc.putc(rxbuff[rxCount]);
      rxCount++;
    }
    
    if(strlen(rxbuff)>64)            // si se ha llenado buffer lo indicamos
    {                                // para que sea revisado
        DataAvailable=1;
    }  
}

//-----------------------------------------------------------------//
// esta funcion imprime en la terminal serial la respuesta a los
// comandoa AT que enviemos al modolo wifi
void reply(int tOut)
{
    tmr1.reset();
    tmr1.start();
    
    wifi.printf("\r\n");
    
    while(tmr1.read_ms()<tOut)
    {
        if(wifi.readable())
        {
            pc.putc(wifi.getc());
        }
    }
    tmr1.stop();
}
//-----------------------------------------------------------------//
// envia el comando en txbuff
void WifiCmd(void)
{
   wifi.printf("%s", txbuff); 
}
//-----------------------------------------------------------------//
// esta funcion crea el servidor web asumiendo que ya estamos conectados
// a una red wifi
void webServerInit(void)
{
    
    strcpy(txbuff,"AT+RST\r\n");                // reseteamos el modulo
    WifiCmd();                                  // enviamos comando a modulo wifi
    reply(5000);                                // mostramos en la terminal la respuesta
    pc.printf("\r\n-----------------------------------------------------------------\r\n"); 

    strcpy(txbuff,"AT+CWMODE=1\r\n");
    WifiCmd();
    reply(2000);         
    pc.printf("\r\n-----------------------------------------------------------------\r\n");
    
    strcpy(txbuff,"AT+CIPMUX=1\r\n");
    WifiCmd();
    reply(2000);
    pc.printf("\r\n-----------------------------------------------------------------\r\n");
    
    strcpy(txbuff,"AT+CIPSERVER=1,80\r\n");
    WifiCmd();
    reply(2000);
    pc.printf("\r\n-----------------------------------------------------------------\r\n");
    
    strcpy(txbuff,"AT+CIFSR\r\n");
    WifiCmd();
    reply(2000);
    pc.printf("\r\n-----------------------------------------------------------------\r\n");
    
    wifi.attach(&sISR);           // habilitamos la lectura de datos enviados desde el
                                  // modulo wifi mediante interrupcion del puerto serial
}

//-----------------------------------------------------------------//

int main() 
{   
    wifi.baud(115200);     // configuramos ambos puertos a 115200 bps
    pc.baud(115200);
    led1 =0;
    led2=0;
    
    pc.printf("\r\n-----------------------Starting----------------------------------\r\n");
    
    wait(3);                   // esperamos  se inicialize el modulo wifi 
    
    webServerInit();           // iniciamos el servidor web
    
    
    while(1) 
    {
      if(DataAvailable)       // si se ha llenado el buffer, detenemos la lectura de caracteres
      {                       // y revisamos si hay una conexion de datos valida
           wifi.attach(NULL);
           rxCount=0;
           DataAvailable=0;
           
           int i = strcspn (rxbuff,"+");   // tomamos el indice apartir del caracter "+"
            
            
           if(i)                       // si existe el caracter "+" dentro de la cadena                      
           {
            strcpy(data, rxbuff + i);       // respaldamos los datos recibidos 
            // leemos el indice, longitud y tipo de conexion       
            int LINK = sscanf(data,"+IPD,%d,%d:%s", &linkID, &ipdLen, type);  
             
            if( strstr(data, "PIN=1") != NULL )  // si encontramos la palabra PIN=1
            {
             led1 = !led1;                       // cambiamos el estado de led1
             pc.printf("TOGGLE LED 1  \r\n");
            }
        
            if( strstr(data,"PIN=2") != NULL )   // si encontramos la palabra PIN=2
            {
             led2 = !led2;                       // cambiamos el estado de led2
             pc.printf("TOGGLE LED 2 \r\n");
            }
            
            if (strstr(data, "GET") != NULL)     // si el metodo de conexion fue GET
            {
             pc.printf("LINKID:%d  IPDLEN:%d  TYPE %s",linkID,ipdLen,type);
  
             sprintf(txbuff,"AT+CIPCLOSE=%d",linkID);  // cerramos la conexion
             WifiCmd();
             reply(100);
            }
            
             memset(data, '\0', sizeof(data));         // inicializamos los buffer de datos
             memset(rxbuff, '\0', sizeof(rxbuff));
        }
        wifi.attach(&sISR);
      }
    }// end while
}// end main

//----------------------------------------------



