/*
  Hotboards temp Library - reading temperature
 Read the temperaure in celsius degrees each two seconds and display
 the value on the serial port.
 The circuit 
 *  VDD   -->  3.3v
 *  SDA   -->  PB_9
 *  SCL   -->  PB_8
 *  GND   -->  GND
 Library and example created by Diego from Hotboards
 Ported to mbed by Pedro from Hotboards
 This example code is in the public domain.
 */
#include "mbed.h"
#include "Hotboards_temp.h"

// new instance of serial port
Serial pc(USBTX, USBRX);
//I2C instance for the library
I2C device( I2C_SDA, I2C_SCL ); 
// instance a sensor with address number 7 (none of the jumpers on the board is short circuted)
// and also 0.5 celsius degrees resolution
Hotboards_temp sensor( device, Sensor_7);


int main( void ) 
{
  // sensor init
  sensor.init();
 
    while(1)
    {   
         // read temperature in celcius degrees
         float temp = sensor.read();
         // print it to the serial port
         pc.printf("Temperature: %3.1f C\r\n",temp);
         // take the next value after 2 sec (just to not read too often)
         wait(1);
    }
}


