#include "mbed.h"
/*
 Hotboards temp Library - Farenheit degrees
 Read the temperaure in celsius and then convert to Farenheit degrees, and also display
 the value on the serial port.
 The circuit 
 *  VDD   -->  3.3v
 *  SDA   -->  PB_9
 *  SCL   -->  PB_8
 *  ALERT -->  PB_13
 *  GND   -->  GND
 Library and example created by Diego from Hotboards
 Ported to mbed by Pedro from Hotboards
 This example code is in the public domain.
 */
#include "mbed.h"
#include "Hotboards_temp.h"

Serial pc(USBTX, USBRX);
//I2C bus instance for the library
I2C device( I2C_SDA, I2C_SCL ); 
// instance a sensor with address number 7 (none of the jumpers on the board is short circuited)
// and also 0.5 celsius degrees resolution
Hotboards_temp sensor( device, Sensor_7);



int main( void ) 
{
    
    // init sensor
    sensor.init();
 
    while(1)
    {           
         // read temperature in celcius degrees
         float temp = sensor.read();
         // convert celcius to fahrenheit
         float tempF = sensor.CelsiusToFarenheit( temp);
         // print it on the serial port
         pc.printf("Temp sensor : %3.1f F\r\n",tempF);
         // take the next value after 2 sec (just to not read too often)
         wait(2);
    }
}
