/*
 Hotboards temp Library - setting alarms
 Set upper and lower alarms and trhoug pin PB_13 monitor the ALERT signal, turn on a led when the
 temperature is below or above the alarm values.
 The circuit 
 *  VDD   -->  3.3v
 *  SDA   -->  PB_9
 *  SCL   -->  PB_8
 *  ALERT -->  PB_13
 *  GND   -->  GND
 Library and example created by Diego from Hotboards
 Ported to mbed by Pedro from Hotboards
 This example code is in the public domain.
 */
#include "mbed.h"
#include "Hotboards_temp.h"

// input pin for reading the alert signal
DigitalIn Alert(PB_13);
// Onboard led
DigitalOut myLed( LED1 );
//new serial port instance
Serial pc(USBTX, USBRX);
//I2C bus instance for the library
I2C device( I2C_SDA, I2C_SCL ); 
// instance a sensor with address number 7 (none of the jumpers on the board is short circuited)
// and also 0.5 celsius degrees resolution
Hotboards_temp sensor( device, Sensor_7);



int main( void ) 
{
    
    // init sensor
    sensor.init();
    // set lower alarm to 0.0 C and upper alarm to 26.0 C. We assume the eviromental temp is around
    // 23-32 degrees
    sensor.setAlarms( 0.0, 30.0 );
 
    while(1)
    {  
         // sense the ALERT signal and turn on/off the led on your Nucleo board
         if(Alert == 0) 
         {
            myLed = 1;
         }
         else
         {
             myLed =0;
         }
         
         // read temperature in celcius degrees
         float temp = sensor.read();
         // print it on the serial port
         pc.printf("Temp sensor 1: %3.1f C\r\n",temp);
         // take the next value after 2 sec (just to not read too often)
         wait(2);
    }
}