/*
  Hotboards_rtcc Library - setting time and date
 Demonstrates the use a MCP7941x clock calendar.  The Hotboards_rtcc
 
 library works with this microchip real time clock
 (http://www.hotboards.org).
 
 This sketch demonstrates how add and substract time values using
 the time span objects
 
  The circuit:
 *  VDD  -->  3.3v
 *  GND  -->  GND
 *  SDA  -->  SDA
 *  SCL  -->  SCL
*/
#include "mbed.h"
#include "Hotboards_rtcc.h"

/* days of the week */
const char *week[] = {"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
/* months of the year */
const char *months[] = {"JAN","FEB","MAR","APR","MAY","JUN", "JUL", "AUG","SEPT","OCT","NOV","DEC"};

/*serial port init*/
Serial pc(USBTX,USBRX);
/*i2c instance delaration for use with the rtcc library*/
I2C device(PB_9, PB_8);
/*lets declare and rtcc instance */
Hotboards_rtcc rtcc(device);

/*function for display date time */
void display_DateTime( DateTime &dt )
{
 printf( " Time- %d:%d:%d  Date- %s/%d/%s/%d \n",dt.hour( ),dt.minute( ),dt.second( ),week[dt.dayOfTheWeek( )],dt.day( ),months[dt.month( )],dt.year());
}


int main() 
{
    /*i2c bus clock set to 100khz*/
   device.frequency(100000);
   /* init the rtcc, just enable the clock if not already enable */
   rtcc.begin();
   /* set the time (15:30:00) and date 1/MAR/2001 */
   rtcc.adjust( DateTime( 2001, 2, 1, 15, 30, 0 ) );
   
    while(1) 
    {
       /* get the actual time and date */
       DateTime time = rtcc.now( );
       /* display through serial port*/
       printf( "Actual time   ");
       display_DateTime( time);
      
       DateTime delta = time + TimeSpan(1, 0, 0, 0); // One day later with TimeSpan addition.
       printf( "1 day later   ");
       display_DateTime( delta);
       
       delta = time + TimeSpan(7, 0, 0, 0); // One week later with TimeSpan addition.
       printf( "one week later");
       display_DateTime( delta);
      
       delta = time + TimeSpan(0, 0, 30, 10); // Fourty two minutes and fourty two seconds later.
       printf( "00:42:42 later");
       display_DateTime( delta);
      
       delta = time - TimeSpan(7, 0, 0, 0);  // One week ago.
       printf( "one week ago  ");
       display_DateTime( delta);
       
       printf( "\n");
       /* wait ten seconds */
       wait( 10 );
    }
}
