/*
  Hotboards_rtcc Library - setting time and date with compiler macros
 Demonstrates the use a MCP7941x clock calendar.  
 The Hotboards_rtcc library works with this microchip real time clock
 (http://www.hotboards.org).
 
 This sketch set time and date using compiler macros, and then send through 
 serial port every five seconds
  The circuit:
 *  VDD  -->  3.3v
 *  GND  -->  GND
 *  SDA  -->  SDA
 *  SCL  -->  SCL
*/
#include "mbed.h"
#include "Hotboards_rtcc.h"

/* days of the week */
const char *week[] = {"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
/* months of the year */
const char *months[] = {"JAN","FEB","MAR","APR","MAY","JUN", "JUL", "AUG","SEPT","OCT","NOV","DEC"};

/*serial port init*/
Serial pc(USBTX,USBRX);
/*i2c instance delaration for use with the rtcc library*/
I2C device(PB_9, PB_8);
/*lets declare and rtcc instance */
Hotboards_rtcc rtcc(device);
#include "mbed.h"


int main() 
{
  /*i2c bus clock set to 100khz*/
  device.frequency(100000);
  /* init the rtcc, just enable the clock if not already enable */
  rtcc.begin();
  /* set the time when is compiled*/
  DateTime time( __DATE__, __TIME__);
  rtcc.adjust(time);                                     
    
    while(1) 
    {
     /* get the actual time and date */
      time = rtcc.now( );
     /* display trough serial port */
     printf( "Time- %d:%d:%d  Date-  %s/ %d/ %s/ %d\n",time.hour( ),time.minute( ),time.second( ),week[time.dayOfTheWeek( )],time.day( ),months[time.month( )],time.year());
     /* wait only five second */
     wait( 5 );
    }
}
