
/*
  Hotboards_rtcc Library - alarm
 Demonstrates the use a MCP7941x clock calendar.  The Hotboards_rtcc
 library works with this microchip real time clock 
 (http://www.hotboards.org).
 
 This sketch set an single alarm that will be active 
 after one minute.
  The circuit:
 *  VDD  -->  3.3v
 *  GND  -->  GND
 *  SDA  -->  SDA
 *  SCL  -->  SCL
 
*/
#include "mbed.h"
#include "Hotboards_rtcc.h"

/* days of the week */
const char *week[] = {"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
/* months of the year */
const char *months[] = {"JAN","FEB","MAR","APR","MAY","JUN", "JUL", "AUG","SEPT","OCT","NOV","DEC"};

/*serial port init*/
Serial pc(USBTX,USBRX);
/*i2c instance delaration for use with the rtcc library*/
I2C device(PB_9, PB_8);
/*lets declare and rtcc instance */
Hotboards_rtcc rtcc(device);

int main() 
{
     /*i2c bus clock set to 100khz*/
    device.frequency(100000);
    /* init the rtcc, just enable the clock if not already enable */
    rtcc.begin();
    /* set the time when is compiled*/
    DateTime time( __DATE__, __TIME__);
    rtcc.adjust(time); 
    
    /* Set an alarm after one minute */
    DateTime alarm = time + TimeSpan( 0, 0, 1, 0 );
    rtcc.setAlarm( alarm );
    /* enable the alarm */
    rtcc.turnOnAlarm( );
  
    printf("The alarm will be active in one minute \n");

    while(1)
    {
       /* is the alarm active?? */
       if( rtcc.getAlarmStatus( ) == 1 )
       {
        /* clear the alarm */
        rtcc.clearAlarm( );
        /* display the time */
        DateTime time = rtcc.now( );
        printf( "Alarm active at:  Time- %d:%d:%d  Date-  %s/ %d/ %s/ %d\n",time.hour( ),time.minute( ),time.second( ),week[time.dayOfTheWeek( )],time.day( ),months[time.month( )],time.year());
       }
    }
}
