/*
  Hotboards_leds.cpp - Driver to control leds one at a time or in group
  Hotboards leds board (http://hotboards.org)
  Created by Diego Perez, January 16, 2016.
  Released into the public domain.
*/

#include "Hotboards_leds.h"

#define bitRead( var, bit )           (((var) >> (bit)) & 0x01)
#define bitWrite( var, bit, val )     (val) ? (var) |= (1<<(bit)) : (var) &= ~(1<<(bit))

Hotboards_leds::Hotboards_leds( PinName led0, bool on )
{
    _leds = 1;
    _state = 0;
    _on = on;
    begin( 0, led0 );
}

Hotboards_leds::Hotboards_leds( PinName led1, PinName led0, bool on )
{
    _leds = 2;
    _state = 0;
    _on = on;
    begin( 0, led0 );
    begin( 1, led1 );
}

Hotboards_leds::Hotboards_leds( PinName led2, PinName led1, PinName led0, bool on )
{
    _leds = 3;
    _state = 0;
    _on = on;
    begin( 0, led0 );
    begin( 1, led1 );
    begin( 2, led2 );
}

Hotboards_leds::Hotboards_leds( PinName led3, PinName led2, PinName led1, PinName led0, bool on )
{
    _leds = 4;
    _state = 0;
    _on = on;
    begin( 0, led0 );
    begin( 1, led1 );
    begin( 2, led2 );
    begin( 3, led3 );
}

Hotboards_leds::Hotboards_leds( PinName led4, PinName led3, PinName led2, PinName led1, PinName led0, bool on )
{
    _leds = 5;
    _state = 0;
    _on = on;
    begin( 0, led0 );
    begin( 1, led1 );
    begin( 2, led2 );
    begin( 3, led3 );
    begin( 4, led4 );
}

Hotboards_leds::Hotboards_leds( PinName led5, PinName led4, PinName led3, PinName led2, PinName led1, PinName led0, bool on )
{
    _leds = 6;
    _state = 0;
    _on = on;
    begin( 0, led0 );
    begin( 1, led1 );
    begin( 2, led2 );
    begin( 3, led3 );
    begin( 4, led4 );
    begin( 5, led5 );
}

Hotboards_leds::Hotboards_leds( PinName led6, PinName led5, PinName led4, PinName led3, PinName led2, PinName led1, PinName led0, bool on )
{
    _leds = 7;
    _state =  0;
    _on = on;
    begin( 0, led0 );
    begin( 1, led1 );
    begin( 2, led2 );
    begin( 3, led3 );
    begin( 4, led4 );
    begin( 5, led5 );
    begin( 6, led6 );
}

Hotboards_leds::Hotboards_leds( PinName led7, PinName led6, PinName led5, PinName led4, PinName led3, PinName led2, PinName led1, PinName led0, bool on )
{
    _leds = 8;
    _state = 0;
    _on = on;
    begin( 0, led0 );
    begin( 1, led1 );
    begin( 2, led2 );
    begin( 3, led3 );
    begin( 4, led4 );
    begin( 5, led5 );
    begin( 6, led6 );
    begin( 7, led7 );
}

void Hotboards_leds::turnOn( uint8_t led )
{
    bitWrite( _state, led, _on );
    _pin[ led ]->write( bitRead( _state, led ) );
    //_pin[ led ]->write( 1 );
}
void Hotboards_leds::turnOff( uint8_t led )
{
    bitWrite( _state, led, !_on );
    _pin[ led ]->write( bitRead( _state, led ) );
    //_pin[ led ]->write( 0 );
}

void Hotboards_leds::toggle( uint8_t led )
{
    if( bitRead( _state, led ) == _on )
    {
        turnOff( led );
    }
    else
    {
        turnOn( led );
    }
}

uint8_t Hotboards_leds::read( uint8_t led )
{
    uint8_t i;
    uint8_t val = 0;

    if( led == 0xff )
    {
        for( i=0 ; i<_leds ; i++ )
        {
            bitWrite( val, i, bitRead( _state, i ) );
        }
    }
    else
    {
        val = bitRead( _state, led );
    }
    return val;
}

void Hotboards_leds::write( uint8_t val )
{
    uint8_t i;
    for( i=0 ; i<_leds ; i++ )
    {
        if( bitRead( val, i ) )
        {
            turnOn( i );
        }
        else
        {
            turnOff( i );
        }
    }
}

void Hotboards_leds::begin( uint8_t led, PinName pin )
{
    // set the digital outpout that holds the led
    _pin[ led ] = new DigitalOut( pin );
    // turn off led (as initial state)
    bitWrite( _state, led, !_on );
    _pin[ led ]->write( !_on );
}
