/*
  Hotboards eeprom Library - write_byte
 Demonstrates the use a spi eeprom. The Hotboards_eeprom
 library works with all Microchip 25xxx serial memory series 
 like the one presented eeprom board (http://www.hotboards.org).
 This sketch read a single byte into a variable, then, the variable is added by two,
 the result is written into memory. Finally, byte is readed again.
 the values are printed to serial port too.
 
 The circuit:
 *  VDD   -->  3.3v
 *  SO    -->  PB_14
 *  SI    -->  PB_15
 *  SCK   -->  PB_13
 *  CS    -->  PC_4
 *  GND   -->  GND
 
 Library  created by Diego from Hotboards
 example added by Pedro from Hotboards
 */
 
#include "mbed.h"
#include "Hotboards_eeprom.h"

/*Open an instance of serial port*/
Serial pc(USBTX,USBRX);
/* initialize an instance of SPI bus,setting the SPI pins*/
SPI device(PB_15,PB_14,PB_13); /* SO, SI, SCK*/  
/*initialize the library with the numbers of the interface pins*/
Hotboards_eeprom eeprom(device,PC_4,HT_EEPROM25xx_32Kb); /* (spi,Cs,Density) */

int main() 
{
    /*SPI transfer at 8 bits, MODE = 3*/
    device.format(8,3);
    /* set the spi frequency to 5MHz  */
    device.frequency(5000000);
    /*initialize CS pin*/
    eeprom.init();
    
    /* variable to read data*/
    char Data;
    
    /* read firts byte*/
    Data=eeprom.read(0);
    /* send to serial port*/
    printf("%X \n",Data); 
    
    /* readed data is added by two */
    Data+= 2;
    /* write the result*/
    eeprom.write(0,Data);
    
    /* read firts byte again*/
    Data=eeprom.read(0);
    /* send to serial port */
    printf("%X \n",Data); 
    
    while(1)
    {
        /*loop*/
    }
    
}