/*
  Hotboards eeprom Library - write_array
 Demonstrates the use a spi eeprom. The Hotboards_eeprom
 library works with all Microchip 25xxx serial memory series 
 like the one presented eeprom board (http://www.hotboards.org).
 This sketch write an array into a memory, then, read back the data 
 and print them to a serial port.
 
 The circuit:
 *  VDD   -->  3.3v
 *  SO    -->  PB_14
 *  SI    -->  PB_15
 *  SCK   -->  PB_13
 *  CS    -->  PC_4
 *  GND   -->  GND
 
 Library  created by Diego from Hotboards
 example added by Pedro from Hotboards
 */
#include "mbed.h"
#include "Hotboards_eeprom.h"
/*Open an instance of serial port*/
Serial pc(USBTX,USBRX);
/* initialize an instance of SPI bus,setting the SPI pins*/
SPI device(PB_15,PB_14,PB_13); /* SO, SI, SCK*/
/*initialize the library with the numbers of the interface pins*/
Hotboards_eeprom eeprom(device,PC_4,HT_EEPROM25xx_32Kb); /* (spi,Cs,Density) */

int main() 
{
    /*SPI transfer at 8 bits, MODE = 3*/
    device.format(8,3);
    /* set the spi frequency to 5MHz  */
    device.frequency(5000000);
    /*initialize CS pin*/
    eeprom.init();
    /*array to be write*/
    uint8_t write_array[]= "[25AA320-EXAMPLE]\n";
    /*array for read */
    uint8_t read_array[20];

    /*write the entire array starting at 0 adress*/
    eeprom.write(0,write_array,sizeof(write_array));
    
    /*read back to "read_array"*/
    eeprom.read(0,(uint8_t*)read_array,20);
    
    /*print adress and data to serial port*/
    printf("ADRESS|DATA \n");
    for(int j=0;j<17;j++)
    {
       printf("%2d      %c \n",j,read_array[j]); 
    }
    
    while(1) 
    {
      /*loop*/
    }
}
