
/*
 * Turn ON a led on pin PA_5 (LED1) if the button on pin PB_4 is pressed, then
 * turn it OFF if the button on pin PB_10 is pressed
 */
 
#include "mbed.h"
#include "Hotboards_buttons.h"

//Creates two single button objects, when the button is pressed it gives you
//a LOW(0) value because it works with pull-ups.
Hotboards_buttons btn1( PB_4 );
Hotboards_buttons btn2( PB_10 );
//If your buttons gives you a HIGH(1) value when is pressed, then we need
//to create the button object with and extra parameter:
//Hotboards_buttons btn( PB_4 , 1 ); in any case the functions will return
//a HIGH(1) value any time the button is pressed

//To our example we will use the led on the nucleo board
DigitalOut nucleoLed( LED1 );

int main()
{
    while(1)
    {
        //The moment when the button is released the function will return a HIGH(1)
        //value, it doesn`t matter if your button is configured with pull-ups(LOW)
        //or pull-downs(HIGH)
        
        //Turn ON the led on the nucleo board when button 1 is pressed
        if( btn1.isPressed( ) )
        {
            nucleoLed = 1;
        }
        
        //Turn OFF the led on the nucleo board when button 2 is presed
        if( btn2.isPressed( ) )
        {
            nucleoLed = 0;
        }
    }
}