
/*
 * Toggle led ON pin PA_5 (LED1) when the button on pin PB_4 is released
 */
 
#include "mbed.h"
#include "Hotboards_buttons.h"

//Creates a single button object, when the button is pressed it gives you
//a LOW(0) value because it works with pull-ups.
Hotboards_buttons btn( PB_4 );
//If your buttons gives you a HIGH(1) value when is pressed, then we need
//to create the button object with and extra parameter:
//Hotboards_buttons btn( PB_4 , 1 ); in any case the functions will return
//a HIGH(1) value any time the button is pressed

//To our example we will use the led on the nucleo board
DigitalOut nucleoLed( LED1 );

int main()
{
    while(1)
    {
        //The moment when the button is released the function will return a HIGH(1)
        //value, it doesn`t matter if your button is configured with pull-ups(LOW)
        //or pull-downs(HIGH)
        if( btn.isReleased( ) )
        {
            //Toggle led on the nucleo board
            nucleoLed = !nucleoLed;
        }       
    }
}
