
/*
 * Reads an input on pin PB_4, only when its value has been changed
 */
 
#include "mbed.h"
#include "Hotboards_switches.h"

// Creates a single sw object, this interrupt will give us a LOW(0) value when close
// because our dip switch works with pull-ups
Hotboards_switches sw( PB_4 );
// If your dip switch will gave you a HIGH(1) value when close, then we need to create
// the sw object with an extra parameter: Hotboards_switches sw( PB_4 , 1 );
// In any case the function will return a HIGH(1) value any time the sw is closed

// For this example we will use the USB serial port, here we initialize it
Serial pc(USBTX,USBRX);

int main()
{
    while(1)
    {
        //Asks when the interrupt changes its value
        if( sw.hasItChange( ) )
        {
            // When the interrupt is close (or ON) the function will return a true value
            // it doesn´t matter if our input is configured with pull-ups(LOW) or
            // pull-downs(HIGH)
            if( sw.read( ) )
            {
                pc.printf( "sw = close (on)\n\r" );
            }
            else
            {
                pc.printf( "sw = open (off)\n\r" );
            }
            // Wait 250 ms, just to not query so often
            wait_ms( 250 );
        }
    }
}
