
/* Library:  Hotboards_switches.h
 * Project:  dip_switch
 * File:     main.cpp
 * Author:   Román Valencia
 *
 * Read an entire dip switch composed by 8 interrupts
 */

#include "mbed.h"
#include "Hotboards_switches.h"

// Creates a single sw object composed by 8 interrupts. theses interrupts will give us a
// LOW(0) value when close because our dip switch works with pull-ups.
Hotboards_switches dip_sw( PA_6 , PA_7 , PB_6 , PC_7 , PA_9 , PA_8 , PB_10 , PB_4 );
// If your dip switch will gave you a HIGH(1) value when close, then we need to create the sw
// object with an extra parameter: 
// Hotboards_switches dip_sw( PA_6 , PA_7 , PB_6 , PC_7 , PA_9 , PA_8 , PB_10 , PB_4 , 1 );
// In any case the functions will return a HIGH(1) value any time the sw is closed

// For this example we will use the USB serial port, here we initialize it
Serial pc(USBTX,USBRX);

int i, j;
uint8_t value;

int main()
{
    while(1)
    {
        // Reads the dip switch and puts it in value
        value = dip_sw.read();
        // Inverts the read value to make it coincide with the state of each
        // switch in binary
        value = ~value;
        // Sends throught USB serial the value in decimal
        pc.printf( "dec = " );
        pc.printf( "%d\r" , value );
        // Sends through USB serial the value in binary
        pc.printf( "bin = " );
        for(i=0;i<8;i++)            //Extracts and shows the binary value of each sw
        { 
            j = value&0x80;         //Applies a mask(10000000) to extract the value of the bit in turn
            j>>=7;                  //Moves this bit 7 positions to the right
            pc.printf("%d",j);      //Sends through USB serial the value of the extracted bit
            value <<=1;             //Moves the position 1 bit to the left to extract the next bit
        }
        pc.printf( "\n\r" );
        wait( 1 );
    }
}
