/*
  Hotboards_SpiLcd Library - setCursor
 Demonstrates the use a 16x2 LCD display.  The Hotboards_SpiLcd
 library works with all LCD displays that are compatible with the
 ST7032 driver presented on Spi Lcd board (http://www.hotboards.org).
 This sketch prints to all the positions of the LCD using the
 setCursor() method:
  
  The circuit:
  *  BKL   -->  GND
  *  VDD   -->  3.3v
  *  GND   -->  GND
  *  SCK   -->  PA_5
  *  SI    -->  PA_6
  *  CS    -->  PB_15
  *  RS    -->  PB_14
  *  RST   -->  PB_13

 Library and example ported by Diego from Hotboards and originally created 
 by David A. Mellis
 library modified 5 Jul 2009
 by Limor Fried (http://www.ladyada.net)
 example added 9 Jul 2009
 by Tom Igoe
 modified 22 Nov 2010
 by Tom Igoe
 */
 
#include "mbed.h"
#include "Hotboards_SpiLcd.h"

/* initialize an instance of SPI bus,setting the SPI pins*/
SPI device(PA_7,PA_6,PA_5); /* SO, SI, SCK*/
/* initialize the library with the numbers of the interface pins*/
Hotboards_SpiLcd display( device, PB_15, PB_14, PB_13 ); /* SPI, CS, RS, RST */


int main() 
{
    /* set the spi frequency to 5MHz*/
    device.frequency(5000000);
    /* initialize internal lcd controller:*/
    display.init();
    
    while(1) 
    {
      // loop from ASCII 'a' to ASCII 'z':
      for (int thisLetter = 'a'; thisLetter <= 'z'; thisLetter++) 
      {
        // loop over the columns:
        for (int  thisRow = 0; thisRow < 2; thisRow++) 
        {
         // loop over the rows:
         for (int thisCol = 0; thisCol < 16; thisCol++) 
         {
          // set the cursor position:
          display.setCursor(thisCol, thisRow);
          // print the letter:
          display.printf("%c",thisLetter);
          wait(0.2);
         }
        }
      }
    }
}
