/*
 Hotboards_SpiLcd - TextDirection
 Demonstrates the use a 16x2 LCD display.  The Hotboards_SpiLcd
 library works with all LCD displays that are compatible with the
 ST7032 driver presented on Spi Lcd board (http://www.hotboards.org).
 This sketch demonstrates how to use leftToRight() and rightToLeft()
 to move the cursor.
 The circuit:
  *  BKL   -->  GND
  *  VDD   -->  3.3v
  *  GND   -->  GND
  *  SCK   -->  PA_5
  *  SI    -->  PA_6
  *  CS    -->  PB_15
  *  RS    -->  PB_14
  *  RST   -->  PB_13
 Library and example ported by Diego from Hotboards and originally created 
 by David A. Mellis
 library modified 5 Jul 2009
 by Limor Fried (http://www.ladyada.net)
 example added 9 Jul 2009
 by Tom Igoe
 modified 22 Nov 2010
 by Tom Igoe
*/
#include "mbed.h"
#include "Hotboards_SpiLcd.h"

/* initialize an instance of SPI bus,setting the SPI pins*/
SPI device(PA_7,PA_6,PA_5); /* SO, SI, SCK*/
/* initialize the library with the numbers of the interface pins*/
Hotboards_SpiLcd display( device, PB_15, PB_14, PB_13 ); /* SPI, CS, RS, RST */

int thisChar = 'a';

int main() 
{
    /* set the spi frequency to 5MHz*/
    device.frequency(5000000);
    /* initialize internal lcd controller:*/
    display.init();
    // turn on the cursor:
    display.cursor();
    
    while(1) 
    {
      // reverse directions at 'm':
      if (thisChar == 'm') 
      {
       // go right for the next letter
       display.rightToLeft();
      }
      // reverse again at 's':
      if (thisChar == 's') 
      {
        // go left for the next letter
        display.leftToRight();
      }
      // reset at 'z':
      if (thisChar > 'z') 
      {
        // go to (0,0):
        display.home();
        // start again at 0
        thisChar = 'a';
      }
      // print the character
      display.printf("%c",thisChar);
      // wait a second:
      wait(1);
      // increment the letter:
      thisChar++;
    }
}
