/*
  Hotboards_Spilcd Library - Cursor

 Demonstrates the use a 16x2 LCD display.  The Hotboards_SpiLcd
 library works with all LCD displays that are compatible with the
 ST7032 driver presented on Spi Lcd board (http://www.hotboards.org).
 This sketch prints "Hello World!" to the LCD and
 uses the cursor()  and noCursor() methods to turn
 on and off the cursor.
 The circuit:
  *  BKL   -->  GND
  *  VDD   -->  3.3v
  *  GND   -->  GND
  *  SCK   -->  PA_5
  *  SI    -->  PA_6
  *  CS    -->  PB_15
  *  RS    -->  PB_14
  *  RST   -->  PB_13
 Library and example ported by Diego from Hotboards and originally created 
 by David A. Mellis
 library modified 5 Jul 2009
 by Limor Fried (http://www.ladyada.net)
 example added 9 Jul 2009
 by Tom Igoe
 modified 22 Nov 2010
 by Tom Igoe
 */
 
#include "mbed.h"
#include "Hotboards_SpiLcd.h"

/* initialize an instance of SPI bus,setting the SPI pins*/
SPI device(PA_7,PA_6,PA_5); /* SO, SI, SCK*/
/* initialize the library with the numbers of the interface pins*/
Hotboards_SpiLcd display( device, PB_15, PB_14, PB_13 ); /* SPI, CS, RS, RST */



int main() 
{
    /* set the spi frequency to 5MHz*/
    device.frequency(5000000);
    /* initialize internal lcd controller:*/
    display.init();
    
    // Print a message to the LCD.
    display.printf("hello, world!");
    
    while(1) 
    {
        // Turn off the cursor:
        display.noCursor();
        wait(0.5);
        // Turn on the cursor:
        display.cursor();
        wait(0.5);
    }
}
