/*
  Hotboards_SpiLcd Library - Writing in diferent rows
  
  Demonstrates the use a 16x2 LCD display, specially the function setCursor.
  The Hotboards_SpiLcd library works with all LCD displays that are compatible with the
  ST7032 driver presented on Spi Lcd board (http://www.hotboards.org).
  
  This sketch prints "Row 1" in the upper row of the LCD
  & prints "Row 2" in the lower row of the LCD
  
  The circuit:
  *  BKL   -->  GND
  *  VDD   -->  3.3v
  *  GND   -->  GND
  *  SCK   -->  PA_5
  *  SI    -->  PA_6
  *  CS    -->  PB_15
  *  RS    -->  PB_14
  *  RST   -->  PB_13
 
  Library ported by Diego from Hotboards and originally created by
  David A. Mellis
  library modified 5 Jul 2009
  by Limor Fried (http://www.ladyada.net)
  example added 
  by Pedro from Hotboards
  This example code is in the public domain.
 */
#include "mbed.h"
#include "Hotboards_SpiLcd.h"

/* initialize an instance of SPI bus,setting the SPI pins*/
SPI device(PA_7,PA_6,PA_5); /* SO, SI, SCK*/
/* initialize the library with the numbers of the interface pins*/
Hotboards_SpiLcd display( device, PB_15, PB_14, PB_13 ); /* SPI, CS, RS, RST */

int main() 
{
    /* set the spi frequency to 5MHz*/
    device.frequency(5000000);
    /* initialize internal lcd controller:*/
    display.init();
    /* Set Cursor on column 2 and Row 0*/
    display.setCursor(2,0);
    /* Print a message */
    display.printf( "Row 1" );
    /* Set Cursor on column 4 and Row 1*/
    display.setCursor(4,1);
    /* Print another message */
    display.printf( "Row 2" );
    
    while(1) 
    {
       /* infinite loop, doing nothing*/
    }
}
