
#include "mbed.h"
#include "Hotboards_keypad.h"

// Defines the keys array with it's respective number of rows & cols,
// and with the value of each key
char keys[ 4 ][ 4 ] =
{
    { '1' , '2' , '3' , 'A' },
    { '4' , '5' , '6' , 'B' },
    { '7' , '8' , '9' , 'C' },
    { '*' , '0' , '#' , 'D' }
};

// Defines the pins connected to the rows
DigitalInOut rowPins[ 4 ] = { PA_6 , PA_7 , PB_6 , PC_7 };
// Defines the pins connected to the cols
DigitalInOut colPins[ 4 ] = { PA_8 , PB_10 , PB_4 , PB_5 };

// Creates a new keyboard with the values entered before
Keypad kpd( makeKeymap( keys ) , rowPins , colPins , 4 , 4 );

// Configures the serial port
Serial pc( USBTX , USBRX );

int main()
{
    pc.printf( "Press any key: " );
    while(1)
    {
        // Poll the keypad to look for any activation
        char key = kpd.getKey( );
        
        // If any key was pressed
        if( key )
        {
            // Display the key pressed on serial port
            pc.printf( "%c" , key );
            pc.printf( "\n\r" );
        }
    }
}
