/* @file Hotboards_keypad.cpp
 || @version 1.1
 || @modified by Diego (http://hotboards.org)
 || @author Alexander Brevig
 || @contact alexanderbrevig@gmail.com
 ||
 || @description
 || | Demonstrates using the KeypadEvent.

 */
#include "mbed.h"
#include "Hotboards_keypad.h"

// Defines the keys array with it's respective number of rows & cols,
// and with the value of each key
char keys[ 4 ][ 4 ] =
{
    { '1' , '2' , '3' , 'A' },
    { '4' , '5' , '6' , 'B' },
    { '7' , '8' , '9' , 'C' },
    { '*' , '0' , '#' , 'D' }
};

// Defines the pins connected to the rows
DigitalInOut rowPins[ 4 ] = { PA_6 , PA_7 , PB_6 , PC_7 };
// Defines the pins connected to the cols
DigitalInOut colPins[ 4 ] = { PA_8 , PB_10 , PB_4 , PB_5 };

// Creates a new keyboard with the values entered before
Keypad kpd( makeKeymap( keys ) , rowPins , colPins , 4 , 4 );

// Configures the serial port
Serial pc( USBTX , USBRX );

// For this example we will use the Nucleo LED1 on pin PA_5
DigitalOut led1( LED1 );
bool blink = false;
bool ledPin_state;


// Taking care of some special events.
void kpdEvent( KeypadEvent key )
{
    switch( kpd.getState( ) )
    {
        case PRESSED:
            if( key == '#' )
            {
                led1 = !led1;
                ledPin_state = led1; // Remember LED state, lit or unlit.
            }
            break;
        case RELEASED:
            if( key == '*' )
            {
                led1 = ledPin_state;
                blink = false; // Restore LED state from before it started blinking.
            }
            break;
        case HOLD:
            if( key == '*' )
            {
                blink = true; // Blink the LED when holding the * key.
            }
            break;
    }
}

int main()
{
    led1 = 1; // Turn the LED on.
    ledPin_state = led1; // Store initial LED state. HIGH when LED is on.
    kpd.addEventListener( kpdEvent ); // Add an event listener for this keypad
    while(1)
    {
        char key = kpd.getKey( );
        if( key )
        {
            pc.printf( "%c" , key );
        }
        if( blink )
        {
            led1 = !led1; // Change the ledPin from Hi2Lo or Lo2Hi
            wait_ms( 100 );
        }
    }
}
