#include "mbed.h"

// Definimos los tonos de frecuencia en Hertz
#define c 261
#define d 294
#define e 329
#define f 349
#define g 391
#define gS 415
#define a 440
#define aS 455
#define b 466
#define cH 523
#define cSH 554
#define dH 587
#define dSH 622
#define eH 659
#define fH 698
#define fSH 740
#define gH 784
#define gSH 830
#define aH 880

// Definimos una matriz con el orden en que se reproducen los tonos
int imperialMarch[] = { a, a, a, f, cH,
                    a, f, cH, a,
                    eH, eH, eH, fH, cH,
                    gS, f, cH, a,
                    aH, a, a, aH, gSH, gH,
                    fSH, fH, fSH,

                    aS, dSH, dH, cSH,
                    cH, b, cH,

                    f, gS, f, a,
                    cH, a, cH, eH,
                    aH, a, a, aH, gSH, gH,
                    fSH, fH, fSH,

                    aS, dSH, dH, cSH,
                    cH, b, cH,

                    f, gS, f, cH,
                    a, f, c, a};

// Definimos otra matriz con la duración de los tonos
int tones[] = { 500, 500, 500, 350, 150,
            500, 350, 150, 1000,
            500, 500, 500, 350, 150,
            500, 350, 150, 1000,
            500, 350, 150, 500, 250, 250,
            125, 125, 250,

            250, 500, 250, 250,
            125, 125, 250,

            125, 500, 375, 125,
            500, 375, 125, 1000,
            500, 350, 150, 500, 250, 250,
            125, 125, 250,

            250, 500, 250, 250,
            125, 125, 250,

            250, 500, 375, 125,
            500, 375, 125, 1000};

// Definimos el número total de tonos que empleamos
int tones_num = 66;

// Establecemos una salida PWM( PB_3 ) para el buzzer, y una digital para el LED
// de la Núcleo( PA_5 ) como indicador de que se está reproduciendo un tono
PwmOut Buzzer(PWM_OUT);
DigitalOut Led1(LED1);

// Definimos una función prototipo                    
void Play_tunes(PwmOut name, int notes, int tones);

// ----- FUNCIÓN PRINCIPAL DEL PROGRAMA -----
int main(void)
{
    // Declaramos una variable i para el siguiente ciclo FOR
    int i;

    // Con este ciclo FOR recorremos cada uno de los tonos y sus duraciones
    for(i=0; i<tones_num; i++)
    {   
        // Mandamos a llamar a la función Play_tunes dandole los valores del
        // pin del buzzer, el valor i de la matriz de notas y de los tonos
        Play_tunes(Buzzer, imperialMarch[i], tones[i]);
        // Aquí separamos las estrofas de nuestra melodía
        if( i == 27 || i == 34 || i == 51 || i == 58 )
        {
            // ... estas estrofas se separan 250ms una de la otra
            wait_ms(250);
        }
    }
}

// Esta es la función Play_tunes que mandamos a llamar dandole algunos
// valores anteriormente
void Play_tunes(PwmOut name, int notes, int tones)
{
    // Declaramos una variable tipo flotante
    float period;
    // Calculamos el periodo de la nota en turno a reproducir
    period = 1000000/notes;
    // Activamos el led de la Núcleo para indicar que estamos reproduciendo
    // una nota
    Led1 = 1;
    // Establecemos el periodo calculado a la salida PWM
    name.period_us(period);
    // Establecemos un ciclo de trabajo del %50
    name.write(0.50f);
    // Esperamos el tiempo establecido por el tono i
    wait_ms(tones);
    // Desactivamos el led de la Núcleo para indicar el fin de la nota
    Led1 = 0;
    // Terminamos la nota
    name.period_us(0);
    // Esperamos un poco para diferenciar entre una nota y otra
    wait_ms(20);
}
