#include "mbed.h"
#include "encoder.h"
#include "HIDScope.h"

#define TSAMP 0.01

void clamp(float * in, float min, float max);
volatile bool looptimerflag;
HIDScope scope(2);
float new_pwm = 2;

void setlooptimerflag(void)
{
    looptimerflag = true;
}

void clamp(float * in, float min, float max)
{
*in > min ? *in < max? : *in = max: *in = min;
}

void looper()
{
    if (new_pwm==2) { // 2 en -2 om aan te tonen dat clamp function ook werkt
        new_pwm = -2;
    } else {
        new_pwm = 2;
    }
}


int main()
{
    //motor 1, 25D
    Encoder motor1(PTD3, PTD5);
    DigitalOut motor1dir(PTC9);
    PwmOut pwm_motor1(PTC8);
    pwm_motor.period_us(100); //10kHz PWM frequency

    //motor 2, 25D
    Encoder motor2(PTD2,PTD0);
    DigitalOut motor2dir(PTA4);
    PwmOut pwm_motor2(PTA5);

    pwm_motor.period_us(100); //10kHz PWM frequency
    Ticker looptimer;
    looptimer.attach(setlooptimerflag,TSAMP);
    Ticker flip_switch;
    flip_switch.attach(looper, 2);

    while(1) {
        while(!looptimerflag);
        looptimerflag = false; //clear flag

        clamp(&new_pwm, -1,1);

        scope.set(0, new_pwm);
        scope.set(1, motor2.getPosition());
        scope.send();

        if(new_pwm > 0)
            motor2dir = 0;
        else
            motor2dir = 1;

        pwm_motor2.write(abs(new_pwm));
    }
}