#include "mbed.h"

PwmOut PulseMotor(p21);
DigitalIn   MotorSpeedSw(p5);
DigitalIn   MotorDirectionSw(p6);
DigitalOut  MotorDirectionOut(p7);

//Add push SW
DigitalIn   WestPushSw(p8);
DigitalIn   EastPushSw(p9);

int main() {
    //Add
    int PreStateWest = 1;
    int PreStateEast = 1;
    
    MotorSpeedSw.mode(PullUp);
    MotorDirectionSw.mode(PullUp);
    //Dorection
    MotorDirectionOut = MotorDirectionSw;
    //Speed
    if (MotorSpeedSw == 1) { //Normal Speed
        PulseMotor.period_us(83140);
        PulseMotor.pulsewidth_us(83140/2);
    }
    else {                     //Half Speed
        PulseMotor.period_us(83140*2);
        PulseMotor.pulsewidth_us((83140*2)/2);
    }
    
    //Add
    WestPushSw.mode(PullUp);
    EastPushSw.mode(PullUp);
     
    while(1) {
        if (WestPushSw != PreStateWest) {
            if (WestPushSw == 0) {
                //pushed West SW
                //double speed
                PulseMotor.period_us(83140/2);
                PulseMotor.pulsewidth_us((83140/2) /2);
            }
            else {
                //relese West SW
                //normal speed
                PulseMotor.period_us(83140);
                PulseMotor.pulsewidth_us(83140 /2);
            }
        }
        if (EastPushSw != PreStateEast) {
            if (EastPushSw == 0) {
                //pushed East SW
                //Stop
                PulseMotor.period_us(83140);
                PulseMotor.pulsewidth_us(0);
            }
            else {
                //relese East SW
                //normal speed
                PulseMotor.period_us(83140);
                PulseMotor.pulsewidth_us(83140 /2);
            }
        }
        //Save SW state
        PreStateWest = WestPushSw;
        PreStateEast = EastPushSw;
        
        wait(0.01);
    }
}


