#include "mbed.h"
#include "SpwfInterface.h"
#include "TCPSocket.h"

Serial pc(USBTX, USBRX, 115200);
DigitalOut led(LED1);

SpwfSAInterface spwf(D8, D2, false);

//www.mbed.com CA certificate in PEM format
char  CA_cert []="-----BEGIN CERTIFICATE-----\r\n"
"MIIDVDCCAjygAwIBAgIDAjRWMA0GCSqGSIb3DQEBBQUAMEIxCzAJBgNVBAYTAlVT\r\n"
"MRYwFAYDVQQKEw1HZW9UcnVzdCBJbmMuMRswGQYDVQQDExJHZW9UcnVzdCBHbG9i\r\n"
"YWwgQ0EwHhcNMDIwNTIxMDQwMDAwWhcNMjIwNTIxMDQwMDAwWjBCMQswCQYDVQQG\r\n"
"EwJVUzEWMBQGA1UEChMNR2VvVHJ1c3QgSW5jLjEbMBkGA1UEAxMSR2VvVHJ1c3Qg\r\n"
"R2xvYmFsIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA2swYYzD9\r\n"
"9BcjGlZ+W988bDjkcbd4kdS8odhM+KhDtgPpTSEHCIjaWC9mOSm9BXiLnTjoBbdq\r\n"
"fnGk5sRgprDvgOSJKA+eJdbtg/OtppHHmMlCGDUUna2YRpIuT8rxh0PBFpVXLVDv\r\n"
"iS2Aelet8u5fa9IAjbkU+BQVNdnARqN7csiRv8lVK83Qlz6cJmTM386DGXHKTubU\r\n"
"1XupGc1V3sjs0l44U+VcT4wt/lAjNvxm5suOpDkZALeVAjmRCw7+OC7RHQWa9k0+\r\n"
"bw8HHa8sHo9gOeL6NlMTOdReJivbPagUvTLrGAMoUgRx5aszPeE4uwc2hGKceeoW\r\n"
"MPRfwCvocWvk+QIDAQABo1MwUTAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQWBBTA\r\n"
"ephojYn7qwVkDBF9qn1luMrMTjAfBgNVHSMEGDAWgBTAephojYn7qwVkDBF9qn1l\r\n"
"uMrMTjANBgkqhkiG9w0BAQUFAAOCAQEANeMpauUvXVSOKVCUn5kaFOSPeCpilKIn\r\n"
"Z57QzxpeR+nBsqTP3UEaBU6bS+5Kb1VSsyShNwrrZHYqLizz/Tt1kL/6cdjHPTfS\r\n"
"tQWVYrmm3ok9Nns4d0iXrKYgjy6myQzCsplFAMfOEVEiIuCl6rYVSAlk6l5PdPcF\r\n"
"PseKUgzbFbS9bZvlxrFUaKnjaZC2mqUPuLk/IH2uSrW4nOQdtqvmlKXBx4Ot2/Un\r\n"
"hw4EbNX/3aBd7YdStysVAq45pmp06drE57xNNB6pXE0zX5IJL4hmXXeXxx12E6nV\r\n"
"5fEWCRE11azbJHFwLJhWC9kXtNHjUStedejV0NxPNO3CBWaAocvmMw==\r\n"
"-----END CERTIFICATE-----\r\n";

int main() {
    pc.printf("\r\n");
    pc.printf("Start Application\r\n");
    
    // Wi-Fi
    pc.printf("\r\n");
    pc.printf("Connecting to AP...\r\n");
    if (spwf.connect("hRPi3-AP", "rlawjdgh", NSAPI_SECURITY_WPA2)) {
        pc.printf("=> Success.\r\n");
    } else {
        pc.printf("=> Failed to connect.\r\n");
        return -1;
    }    
    const char* ip = spwf.get_ip_address();
    pc.printf("=> IP Address is: %s\r\n", (ip) ? ip : "No IP");
    const char* mac = spwf.get_mac_address();   
    pc.printf("=> MAC Address is: %s\r\n", (mac) ? mac : "No MAC");
    
    // DNS
/*
    pc.printf("\r\n");
    pc.printf("DNS Testing...\r\n");
    SocketAddress addr(&spwf, "st.com");
    pc.printf("<st.com> is resolved to: %s\r\n", addr.get_ip_address());
*/
    // Unsecured TCP
/*
    pc.printf("\r\n");
    pc.printf("Unsecured TCP Testing...\r\n");
    TCPSocket socket(&spwf);
    pc.printf("Connecting to <4.ifcfg.me>...\r\n");
    int err = socket.connect("4.ifcfg.me", 23);
    if (err) {
      pc.printf("=> Failed to connect. (%d)\r\n", err);
      return -1;
    } else {
        pc.printf("=> Success.\r\n");
    }    
    pc.printf("Receiving Data\r\n");         
    char buffer[100];
    int count = socket.recv(buffer, sizeof buffer);    
    if (count > 0) {
        buffer[count] = '\0';
        printf("=> %s\r\n", buffer);  
    }
    else {
        pc.printf("=> Nothing to receive.\r\n");
    }
    pc.printf("Close TCP socket\r\n");
    socket.close();
*/  
    // Secured TCP
    pc.printf("\r\n");
    pc.printf("Secured TCP Testing...\r\n");
    if (!spwf.clean_TLS_certificate(ALL))
        pc.printf("=> Failed to clean TLS certificate\r\n");
    if (!spwf.set_TLS_certificate(CA_cert, sizeof(CA_cert), FLASH_CA_ROOT_CERT)) 
        pc.printf("=> Failed to set TLS certificate\r\n");
    if (!spwf.set_TLS_SRV_domain("*.mbed.com", FLASH_DOMAIN))
        printf("=> Failed to set TLS CA domain\r\n");
    spwf.set_secure_mode();
    TCPSocket socket(&spwf);
    spwf.set_unsecure_mode();
    int err = socket.connect("www.mbed.com", 443);
    if (err != 0)
        pc.printf("=> Failed to connect. (%d)\r\n", err);
    else
        pc.printf("=> Success.\r\n");
    pc.printf("Close TCP socket\r\n");
    socket.close();
           
    pc.printf("Disconnect from AP\r\n");
    spwf.disconnect();
    
    while (1) {
        led = !led;
        wait(0.5);
    }
}
  