#include "mbed.h"
#include "hts221.h"
#include "DeviceInformationService.h"

#define ON 1
#define OFF 0

DigitalOut myled2(LED2);
DigitalOut myled1(LED1);


int main() {
    
    float temp = 12.0;
    int tempint = static_cast<int> (temp);
    int tempdigit1 = 0;
    int tempdigit10 = 0;

    float humi = 55;
    int humiint = static_cast<int> (humi);
    int humidigit1 = 0;
    int humidigit10 = 0;
    int i = 0; 
    
    
    if (hts221_init()) { //Check if the sensor is initialized correctly
        HTS221_Calib(); //calibrate thermometer
        while(true) {   //Infinite loop
            
            HTS221_ReadTempHumi(&temp, &humi);
            
            tempint = static_cast<int> (temp);
            tempdigit1 = tempint % 10;
            tempdigit10 = tempint / 10;
            for (i = tempdigit10 ; i ; i--) {
                myled1 = ON; 
                wait (0.5);
                myled1 = OFF ;
                wait (1.0);
            }
            for (i = tempdigit1 ; i ; i--) {
                myled1 = ON; 
                wait (0.1);
                myled1 = OFF ;
                wait (0.4);
            }         
            
            humiint = static_cast<int> (humi);
            humidigit1 = humiint % 10;
            humidigit10 = humiint / 10;
            for (i = humidigit10 ; i ; i--) {
                myled2 = ON; 
                wait (0.5);
                myled2 = OFF ;
                wait (1.0);
            }
            for (i = humidigit1 ; i ; i--) {
                myled2 = ON; 
                wait (0.1);
                myled2 = OFF ;
                wait (0.4);
            }         
            
            wait (4.0);
        }
    } else {    //Sensor initialize error
        while(true) {
            myled1 = ON;
            wait(0.1);
            myled1 = OFF;
            wait(0.2);
        }
    }
}
    