#include <mbed.h>
#include <stdio.h>
#include <cstring>
#include <fstream>

#define USE_RTK2GO

int NBR_CHAR_SENT;
int SEND_DATA_TRIES;
int REQUEST_RTK2GO_TRIES;
  
#define BUFFER_SIZE 1024*2
#define RX_TIMEOUT_MS 450

/*
    2OE = 0 then : RXD_ZED <- TXD3_ODIN_W2 : RXD3_ODIN <- TXD_ZED
*/
 
//DigitalOut SWITCH_2OE(PA_12);

typedef enum 
    {
        SM_STATE_WIFI_CNX,
        SM_STATE_SOCKET_CNX,
        SM_STATE_AUTHENTIFICATION,
        SM_STATE_PRE_CONNECTED,
        SM_STATE_CONNECTED,
    } SM_STATE_TYPEDEF;

WiFiInterface *wifi;

TCPSocket socket;

// Create a BufferedSerial 
Serial UART1(PA_9, PA_10, 460800);
Serial UART3(PD_8, PD_9 , 460800);


DigitalOut LedRed(LED_RED);     // red
DigitalOut LedGreen(LED_GREEN); // green
DigitalOut LedBlue(LED_BLUE);   // blue

DigitalOut R_LedRed(LED_RED);

char buf[BUFFER_SIZE];
unsigned int bufIndex=0;;
bool RxTriggred=false;
SM_STATE_TYPEDEF state;

uint32_t TotalRxCounter=0;
uint32_t TotalTxCounter=0;

// Read data from uart1
// Thread DataRxHandler;
void DataRx()
{
   
   while(UART1.readable())
   {
        const char x=UART1.getc();
        if (state==SM_STATE_CONNECTED)
        {
            buf[bufIndex]=x;
            if (bufIndex<BUFFER_SIZE)
                {
                    bufIndex++;
                    TotalRxCounter++;
                }
            else
            {
                bufIndex=0;
                bufIndex++;
                }
        }
        else
            bufIndex=0;
        
        RxTriggred=true;
    }
}

bool Sending=false;

// Send data to server
Thread DataTxHandler;
void DataTx()
{
   while(1)
    {
        if(Sending)
        {
            RxTriggred=false;
            thread_sleep_for(RX_TIMEOUT_MS);  
            if ((RxTriggred==false)&&(bufIndex>0))
            {
                NBR_CHAR_SENT=socket.send(buf, bufIndex);
                if(NBR_CHAR_SENT<0){
                    SEND_DATA_TRIES++;
                }
                else{
                    TotalTxCounter=TotalTxCounter+bufIndex;
                    SEND_DATA_TRIES=0;
                }

                memset(&buf,0,BUFFER_SIZE);
                bufIndex=0;
                if(SEND_DATA_TRIES>0)
                    printf("Error sending to server = %d \n",SEND_DATA_TRIES);
                if(SEND_DATA_TRIES>=5)
                {
                    socket.close();
                    if(wifi->get_connection_status()!=1){
                        wifi->disconnect();
                        state=SM_STATE_WIFI_CNX;
                        printf("\nRe");
                        }
                    else
                    {
                        state=SM_STATE_SOCKET_CNX;
                        printf("\nRe-");
                    }
                    SEND_DATA_TRIES=0;
                    UART1.attach(0);
                    Sending=false;                   
                }
            }
        }
    }
    
}

// Receive data from the server
bool socket_stauts = true;
void receiveTCP() {
    printf ("start receive\r\n");
    // Allocate 2K of data
    char* data = (char*)malloc(8192);
    while (1) {
        // recvfrom blocks until there is data
        nsapi_size_or_error_t size = socket.recv(data, 4096);
        if (size < 0) {
            if (size == NSAPI_ERROR_WOULD_BLOCK) {  // Would block... that's fine (no data on the line)
                thread_sleep_for(100);
                continue;
            }
            printf("Error while receiving data from TCP socket, probably it's closed now? (%d)\r\n", size);
            break;
        }
        // turn into valid C string
        data[size] = '\0';        
        //thread_sleep_for(100);
        printf("Received %4d bytes from TCP socket \r\n", size);
        UART3.write(data,size);
    }
}

typedef enum 
    {
        CLWHITE,
        CLYELLOW,
        CLCYAN,
        CLBLUE,
        CLGREEN,
        CLRED   
    } COLOR_TYPEDEF;

void LED_SetColor(COLOR_TYPEDEF Color)
{
    switch (Color)
    {
        case CLGREEN : LedRed=1;LedGreen=0;LedBlue=1; break;
        case CLCYAN :LedRed=1;LedGreen=0;LedBlue=0; break;
        case CLBLUE : LedRed=1;LedGreen=1;LedBlue=0; break;
        case CLWHITE : {
            DigitalOut W_lEDRed(LED_RED,0);
            DigitalOut W_LedGreen(LED_GREEN,0);
            DigitalOut W_LedBlue(LED_BLUE,0);
        }
        break;
        case CLYELLOW : {
            DigitalOut Y_lEDRed(LED_RED,0);
            DigitalOut Y_LedGreen(LED_GREEN,0);
            DigitalOut Y_LedBlue(LED_BLUE,1);
        }
        break;
        case CLRED : {
            DigitalOut R_LedRed(LED_RED,0);
            DigitalOut R_LedGreen(LED_GREEN,1);
            DigitalOut R_LedBlue(LED_BLUE,1);
        } 
         break;
        
        default : LedRed=1;LedGreen=1;LedBlue=1; break;
     }
}

void _eraseFlash(void)
{
	FLASH_EraseInitTypeDef erase;
	erase.TypeErase = FLASH_TYPEERASE_SECTORS;  /* Select sector    */
	erase.Sector = FLASH_SECTOR_23;             /* Set sector 23    */
    erase.Banks = FLASH_BANK_2;                 /* Erase bank =2    */
	erase.NbSectors = 1;		                /* Erase sector num */
	erase.VoltageRange = FLASH_VOLTAGE_RANGE_3; /* Driver 3.3V      */

	uint32_t pageError = 0;

	HAL_FLASHEx_Erase(&erase, &pageError);	    /* Erase use by HAL_FLASHEx */
}

void writeFlash(uint32_t address, uint8_t *data, uint32_t size)
{
	HAL_FLASH_Unlock();		                    /* Unlock FLASH */
	_eraseFlash();			                    /* Erase sector 23 */
	do {
		HAL_FLASH_Program(FLASH_TYPEPROGRAM_BYTE, address, *data);
	} while (++address, ++data, --size);
	HAL_FLASH_Lock();		                    /* Lock FLASH */
}

void loadFlash(uint32_t address, uint8_t *data, uint32_t size)
{
	memcpy(data, (uint8_t*)address, size);
}

typedef struct {
	char    wifi_ssid[20];
	char	wifi_passwd[20];
	char	ntrip_server[20];
    char	ntrip_user[20]="";
    char	ntrip_passwd[20];
    char	ntrip_mountpt[20];
} NTRIP_Condition;

bool exitLoop=false;
int main(void)
{
    Thread socket_thread;
    //UART3.format (8,SerialBase::None,1);


    printf("===================  EVK-ODIN-W2-NTRIP-CLIENT-CR3 ===================\n");
    printf("===================  C099-F9P NTRIP Setting Part  ===================\n");

    mbed_stats_sys_t stats;
    mbed_stats_sys_get(&stats);
    printf("\n ---- ODIN-W2 Status -----\r\n");
    printf("Mbed OS version %d.%d.%d\r\n", MBED_MAJOR_VERSION, MBED_MINOR_VERSION, MBED_PATCH_VERSION);
    printf("CPU ID: 0x%x\r\n", stats.cpu_id);
    printf("Compiler ID: %d\r\n", stats.compiler_id);
    printf("Compiler Version: %ld\r\n", stats.compiler_version);

	const uint32_t address = 0x81E0000;
	NTRIP_Condition ntrip_condition;

    loadFlash(address, (uint8_t*)&ntrip_condition, sizeof(NTRIP_Condition));
    printf (" -------------------------\r\n");
    printf ("| Current C099 conditions |\r\n");
    printf (" -------------------------\r\n");
    printf ("WiFi SSID      = %s \r\n" , ntrip_condition.wifi_ssid );
    printf ("WiFi Password  = %s \r\n" , ntrip_condition.wifi_passwd );
    printf ("Ntrip Server   = %s \r\n" , ntrip_condition.ntrip_server );
    printf ("Ntrip Password = %s \r\n" , ntrip_condition.ntrip_passwd );
    printf ("Ntrip Mounpt   = %s \r\n" , ntrip_condition.ntrip_mountpt );

    DigitalIn switch_in0(SW0);              // PUSH = 0 ;
    switch_in0.mode(PullUp);
    int x = switch_in0;
    int y = 1;

    char buffer[4]="OK";

    printf (" --------------------------------------------\r\n");
    printf ("| If you release RESET while turning on SW0, |\r\n");
    printf ("| C099 will enter the condition change mode. |\r\n");
    printf (" --------------------------------------------\r\n");

    while( (strstr(buffer,"OK") == NULL) || ( x == 0 ) ) // if SW0 is PUSH -> Change Condition
    {
        x = 1 ;
        y = 0 ;
        printf ("Please Input Condition\r\n");

        printf("\r\nWiFi SSID = ");
        scanf ("%s" , ntrip_condition.wifi_ssid );
        printf("%s\r\nWiFi Password = "              ,ntrip_condition.wifi_ssid);
        scanf ("%s" , ntrip_condition.wifi_passwd );
        printf("%s\r\nNtrip Server (ex:rtk2go.com)= ",ntrip_condition.wifi_passwd);
        scanf ("%s" , ntrip_condition.ntrip_server );
        printf("%s\r\nNtrip Server Passwd ="         ,ntrip_condition.ntrip_server);
        scanf ("%s" , ntrip_condition.ntrip_passwd );
        printf("%s\r\nNtrip Server Mount Point="     ,ntrip_condition.ntrip_passwd);
        scanf ("%s" , ntrip_condition.ntrip_mountpt );
        printf("%s\r\n"                              ,ntrip_condition.ntrip_mountpt);

        printf (" -------------------------\r\n");
        printf ("| Changed C099 conditions |\r\n");
        printf (" -------------------------\r\n");
        printf ("WiFi SSID      = %s \r\n" , ntrip_condition.wifi_ssid );
        printf ("WiFi Password  = %s \r\n" , ntrip_condition.wifi_passwd );
        printf ("Ntrip Server   = %s \r\n" , ntrip_condition.ntrip_server );
        printf ("Ntrip Password = %s \r\n" , ntrip_condition.ntrip_passwd );
        printf ("Ntrip Mounpt   = %s \r\n" , ntrip_condition.ntrip_mountpt );
        printf (" -----------------------------------------------------------------------\r\n");
        printf ("| If this is all right, enter \"OK\". If not, enter \"NG\". (and ENTER) |\r\n");
        printf (" -----------------------------------------------------------------------\r\n");

        scanf("%s", buffer);
        printf("%s\r\n",buffer);
    } 

	if ( y == 0 ) {
        printf ("Write changed condition\r\n");
        writeFlash(address, (uint8_t*)&ntrip_condition, sizeof(NTRIP_Condition));
    }

    printf ("NEXT\r\n");

    /***********************************************************************************************/
    /*                                                                                             */
    /***********************************************************************************************/

    LED_SetColor(CLWHITE);
    thread_sleep_for(2000);
      
    printf("===================  C099-F9P & RTK2GO example  ===================\r\n");
    state=SM_STATE_WIFI_CNX;
    NBR_CHAR_SENT=0;
    SEND_DATA_TRIES=0;
    REQUEST_RTK2GO_TRIES=0;
    
    while (!exitLoop){
        switch(state){
            case SM_STATE_WIFI_CNX:
                {
                    printf("\n>SM_STATE:SM_STATE_WIFI_CNX\r\n");
                    LED_SetColor(CLCYAN);
                    printf("connecting to %s...\r\n", ntrip_condition.wifi_ssid);
                    wifi = WiFiInterface::get_default_instance();
                    int ret=1;
                    ret = wifi->connect(ntrip_condition.wifi_ssid, ntrip_condition.wifi_passwd, NSAPI_SECURITY_WPA_WPA2);
                    if (ret != 0) {
                        printf("\nConnection error: %d\r\n", ret);
                    }
                    else {
                        printf("Success\n\n");
                        printf("MAC: %s\r\n", wifi->get_mac_address());
                        printf("IP: %s\r\n", wifi->get_ip_address());
                        printf("Netmask: %s\r\n", wifi->get_netmask());
                        printf("Gateway: %s\r\n", wifi->get_gateway());
                        printf("RSSI: %d\r\n", wifi->get_rssi());
                        state=SM_STATE_SOCKET_CNX;
                    }
                }
            break;
            
            case SM_STATE_SOCKET_CNX:
                {
                   printf("\n>SM_STATE:SM_STATE_SOCKET_CNX\r\n");
                   LED_SetColor(CLBLUE);
                   printf("opening socket\r\n");
                   if(wifi->get_connection_status()==1){
                       int result =socket.open(wifi);
                       if (result != 0) printf("Error! socket.open() returned: %d\r\n", result);
                       else{
                           printf("Connecting to socket\n");
                           nsapi_error_t err=NSAPI_ERROR_NO_CONNECTION;
                           err=socket.connect( ntrip_condition.ntrip_server , MBED_CONF_APP_NTRIP_SERVER_PORT );
                           if (err != NSAPI_ERROR_OK){
                               printf("Unable to connect to (%s) on port (%d) err (%d)\n", ntrip_condition.ntrip_server , MBED_CONF_APP_NTRIP_SERVER_PORT,err);
                               socket.close();
                               thread_sleep_for(2000);
                           }
                               else
                               {
                                   printf("Connected to Server at %s\n",ntrip_condition.ntrip_server);
                                   #ifdef USE_RTK2GO
                                       state=SM_STATE_AUTHENTIFICATION;
                                       // state=SM_STATE_PRE_CONNECTED;
                                   #else
                                       state=SM_STATE_PRE_CONNECTED;
                                   #endif
                               }
                       }          
                   }
                   else state=SM_STATE_WIFI_CNX;
               }
            break;
                    
            case SM_STATE_AUTHENTIFICATION:
               {
                   char buffer[10];
                   printf("\n>SM_STATE:SM_STATE_AUTHENTIFICATION\n");
                   LED_SetColor(CLBLUE);
                   string s = string("GET /")+string(ntrip_condition.ntrip_mountpt)+string(" HTTP/1.0\r\nUser-Agent: NTRIP Client/C099\r\nAccept: */*\r\nConnection: close\r\n\r\n");
                   char dataToSend[s.size()+1];
                   s.copy(dataToSend, s.size()+1);
                   dataToSend[s.size()]='\0';
                   printf("Request confirmation from server\n");
                   socket.send(dataToSend, sizeof(dataToSend) - 1);
                   thread_sleep_for(1000);
                   int b = socket.recv(buffer, 10);
                   buffer[b] = '\0';
                   if (strstr(buffer,"ICY 200 OK")!=NULL)
                       {
                            printf("Response from server: '%s'\n", buffer);
                            UART3.printf("Response from server: '%s'\n", buffer);
                            socket_thread.start(&receiveTCP);
                            //SWITCH_2OE=0;
                            state=SM_STATE_CONNECTED;
                       }
                   else
                   {
                       printf("Can't get the confirmation from server\n");
                       printf("Error Message=%s",buffer);
                       REQUEST_RTK2GO_TRIES++;
                       if(REQUEST_RTK2GO_TRIES>0)
                       {
                           if(REQUEST_RTK2GO_TRIES>=3)
                           {
                               printf("\nError getting confirmation from server\n");
                               thread_sleep_for(2000);
                               exitLoop=true;
                           }
                           else 
                           {
                               printf("\nRetry ");
                               thread_sleep_for(2000);
                           }
                       }
                   }                       
               }
            break;

            case SM_STATE_CONNECTED:
                {
                    if (switch_in0 == 0 ) {
                        printf("\r\n\r\nSM_STATE:SM_STATE_CONNECTED\r\nr\n");
                    }
                     thread_sleep_for(5000000);   
                }
            break;
        }
        thread_sleep_for(100);
    }
 
    LED_SetColor(CLRED);
    printf("Error !  Verify the server state then reset your device \n");
    
    while(1)
    {
        R_LedRed= !R_LedRed;
        thread_sleep_for(300);
    }

	return 0;
}