/* Copyright 2017-present Renesas Electronics Corporation and other contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


isGraphics = function(arg) {
  return arg instanceof Graphics;
}

function convert_buffer_format(format) {
	switch(format) {
//	case 'ycbcr422':	return native.BUFFERFORMAT.YCBCR422;
	case 'rgb565':		return native.BUFFERFORMAT.RGB565;
	case 'rgb888':		return native.BUFFERFORMAT.RGB888;
	case 'argb8888':	return native.BUFFERFORMAT.ARGB8888;
	case 'argb4444':	return native.BUFFERFORMAT.ARGB4444;
	default:			return native.BUFFERFORMAT.MAX;
	}
}

function Graphics(config) {
  if (!isGraphics(this)) {
    return new Graphics(config);
  }
  native(this, {
    buf: config.buf,
    width: config.width,
    height: config.height,
    format: convert_buffer_format(config.format)
  });
  this.frameBuffer = config.buf;
  this.bufferWidth = config.width;
  this.bufferHeight = config.height;
  this.bufferFormat = config.format;
}

Graphics.prototype.drawImage = function(image, x, y) {
  native.drawImage(this, image, x, y);
};

Graphics.prototype.drawLine = function(startX, startY, endX, endY, color) {
  native.drawLine(this, startX, startY, endX, endY, color);
};

Graphics.prototype.drawRect = function(x, y, width, height, color, fill) {
  native.drawRect(this, x, y, width, height, color, fill ? true : false);
};

Graphics.prototype.drawArc = function(centerX, centerY, radius, startAngle, endAngle, color) {
  native.drawArc(this, centerX, centerY, radius, startAngle, endAngle, color);
};

Graphics.prototype.drawCircle = function(centerX, centerY, radius, color, fill) {
  native.drawCircle(this, centerX, centerY, radius, color, fill ? true : false);
};

Graphics.prototype.drawEllipse = function(centerX, centerY, radiusX, radiusY, color, fill) {
  native.drawEllipse(this, centerX, centerY, radiusX, radiusY, color, fill ? true : false);
};

Graphics.prototype.drawPolygon = function(centerX, centerY, radius, sides, color, fill) {
  native.drawPolygon(this, centerX, centerY, radius, sides, color, fill ? true : false);
};

Graphics.prototype.drawText = function(text, x, y, size, color, background) {
  native.drawText(this, text, x, y, size, color, background);
};

module.exports = Graphics;
module.exports.Graphics = Graphics;
