/* Copyright 2017-present Renesas Electronics Corporation and other contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function isArray(arg) { return arg instanceof Array; }
function isFixup(arg) { return arg instanceof Fixup; }

function Fixup(modules) {
	modules = isArray( modules ) ? modules : [].slice.call( arguments );
	if( !isFixup( this ) ) {
		return new Fixup( modules );
	}

	for( var i=0; i<modules.length; ++i ) {
		switch( modules[ i ] ) {
		case 'http':
		case 'https':	fixup_http();	break;
//		case 'etc':		fixup_etc();	break;
		}
	}
}

function fixup_http() {
	var http = require('http');
	if( http.ClientRequest.prototype.original_write ) {
		return;
	}
	http.ClientRequest.prototype.original_write = http.ClientRequest.prototype.write;
	http.ClientRequest.prototype.write = function( data ) {
		var block_size = 4096;
		for( var i=0; i<data.length; i+=block_size ) {
			this.original_write( data.slice( i, i+block_size ) );
		}
	};
}

module.exports = Fixup;
module.exports.Fixup = Fixup;

