const http = require('http');
const fs = require('fs');

/************/
/* settings */
/************/
const port      = 8000;			// HTTPサーバのポート番号
const maxFileNo = 100;			// JPEGファイル数の上限
const path      = './jpeg/';	// JPEGファイル保存フォルダ
/************/

/* 画像保存ディレクトリ作成 */
try {
	fs.mkdirSync(path);
} catch(err) {
	if(err.code != 'EEXIST') {
		console.log(err);
		process.exit();
	}
}

var fileNo = 1;
var i = 0;
/* サーバの作成 */
const server = http.createServer(function(req, res) {
	var body = '';
	req.on('data', function(chunk) {
//		console.log('chunk.length : ' + chunk.length);
		body += chunk;
	});
	req.on('end', function() {
		/* 受信したデータをファイルに保存 */
		try {
			var obj = JSON.parse(body);
			var image = Buffer.from(obj.image, 'base64');
			console.log(++i, 'Write : ' + path + 'image' + fileNo + '.jpg');
			fs.writeFileSync(path + fileNo + '.jpg', image);
			fileNo = (fileNo < maxFileNo) ? (fileNo + 1) : 1;
		} catch(err) {
			console.log(err);
		}

		/* クライアントへ OK を固定で返す */
		res.setHeader('Content-Type', 'text/html');
		res.writeHead(200, { 'Content-Type': 'text/plain' });
		res.end('OK');
	});
	req.on('error', function(err) {
		/* エラー終了 */
		console.log(err);
		res.end();
	});
});
server.listen(port);
